/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.language;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.wikipedia.dataclient.R;

public class AppLanguageLookUpTable {
    public static final String SIMPLIFIED_CHINESE_LANGUAGE_CODE = "zh-hans";
    public static final String TRADITIONAL_CHINESE_LANGUAGE_CODE = "zh-hant";
    public static final String CHINESE_CN_LANGUAGE_CODE = "zh-cn";
    public static final String CHINESE_HK_LANGUAGE_CODE = "zh-hk";
    public static final String CHINESE_MO_LANGUAGE_CODE = "zh-mo";
    public static final String CHINESE_SG_LANGUAGE_CODE = "zh-sg";
    public static final String CHINESE_TW_LANGUAGE_CODE = "zh-tw";
    public static final String CHINESE_YUE_LANGUAGE_CODE = "zh-yue";
    public static final String CHINESE_LANGUAGE_CODE = "zh";
    public static final String NORWEGIAN_LEGACY_LANGUAGE_CODE = "no";
    public static final String NORWEGIAN_BOKMAL_LANGUAGE_CODE = "nb";
    public static final String TEST_LANGUAGE_CODE = "test";
    public static final String FALLBACK_LANGUAGE_CODE = "en";
    @NonNull
    private final Resources resources;
    @NonNull
    private SoftReference<List<String>> codesRef = new SoftReference<Object>(null);
    @NonNull
    private SoftReference<List<String>> canonicalNamesRef = new SoftReference<Object>(null);
    @NonNull
    private SoftReference<List<String>> localizedNamesRef = new SoftReference<Object>(null);

    public AppLanguageLookUpTable(@NonNull Context context) {
        this.resources = context.getResources();
    }

    @NonNull
    public List<String> getCodes() {
        List<String> codes = this.codesRef.get();
        if (codes == null) {
            codes = this.getStringList(R.array.preference_language_keys);
            this.codesRef = new SoftReference<List<String>>(codes);
        }
        return codes;
    }

    @Nullable
    public String getCanonicalName(@Nullable String code) {
        String name = this.defaultIndex(this.getCanonicalNames(), this.indexOfCode(code), null);
        if (TextUtils.isEmpty((CharSequence)name) && !TextUtils.isEmpty((CharSequence)code)) {
            if (code.equals(Locale.CHINA.getLanguage())) {
                name = Locale.CHINA.getDisplayName(Locale.ENGLISH);
            } else if (code.equals(NORWEGIAN_LEGACY_LANGUAGE_CODE)) {
                name = this.defaultIndex(this.getCanonicalNames(), this.indexOfCode(NORWEGIAN_BOKMAL_LANGUAGE_CODE), null);
            }
        }
        return name;
    }

    @Nullable
    public String getLocalizedName(@Nullable String code) {
        String name = this.defaultIndex(this.getLocalizedNames(), this.indexOfCode(code), null);
        if (TextUtils.isEmpty((CharSequence)name) && !TextUtils.isEmpty((CharSequence)code)) {
            if (code.equals(Locale.CHINA.getLanguage())) {
                name = Locale.CHINA.getDisplayName(Locale.CHINA);
            } else if (code.equals(NORWEGIAN_LEGACY_LANGUAGE_CODE)) {
                name = this.defaultIndex(this.getLocalizedNames(), this.indexOfCode(NORWEGIAN_BOKMAL_LANGUAGE_CODE), null);
            }
        }
        return name;
    }

    private List<String> getCanonicalNames() {
        List<String> names = this.canonicalNamesRef.get();
        if (names == null) {
            names = this.getStringList(R.array.preference_language_canonical_names);
            this.canonicalNamesRef = new SoftReference<List<String>>(names);
        }
        return names;
    }

    private List<String> getLocalizedNames() {
        List<String> names = this.localizedNamesRef.get();
        if (names == null) {
            names = this.getStringList(R.array.preference_language_local_names);
            this.localizedNamesRef = new SoftReference<List<String>>(names);
        }
        return names;
    }

    public boolean isSupportedCode(@Nullable String code) {
        return this.getCodes().contains(code);
    }

    private <T> T defaultIndex(List<T> list, int index, T defaultValue) {
        return this.inBounds(list, index) ? list.get(index) : defaultValue;
    }

    private int indexOfCode(@Nullable String code) {
        return this.getCodes().indexOf(code);
    }

    @NonNull
    private List<String> getStringList(int id) {
        return Arrays.asList(this.getStringArray(id));
    }

    private boolean inBounds(List<?> list, int index) {
        return index >= 0 && index < list.size();
    }

    public String[] getStringArray(@ArrayRes int id) {
        return this.resources.getStringArray(id);
    }
}

