/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.wikidata;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.gson.JsonParseException;
import org.wikipedia.dataclient.Service;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.wikidata.Entities;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public final class EntityClient {
    public static final String WIKIDATA_WIKI = "wikidatawiki";

    public void getLabelForLang(@NonNull String qNumber, @NonNull String langCode, @NonNull LabelCallback callback) {
        this.requestLabels(ServiceFactory.get(new WikiSite("https://www.wikidata.org/")), qNumber, langCode).enqueue((Callback)new LabelCallbackAdapter(callback, qNumber, langCode));
    }

    @VisibleForTesting
    @NonNull
    Call<Entities> requestLabels(@NonNull Service service, @NonNull String qNumber, @NonNull String langCode) {
        return service.getWikidataLabels(qNumber, langCode);
    }

    @VisibleForTesting
    static class LabelCallbackAdapter
    implements Callback<Entities> {
        @NonNull
        private final LabelCallback callback;
        @NonNull
        private final String qNumber;
        @NonNull
        private final String langCode;

        LabelCallbackAdapter(@NonNull LabelCallback callback, @NonNull String qNumber, @NonNull String langCode) {
            this.callback = callback;
            this.qNumber = qNumber;
            this.langCode = langCode;
        }

        public void onResponse(@NonNull Call<Entities> call, @NonNull Response<Entities> response) {
            if (response.body() != null) {
                for (Entities.Entity item : ((Entities)response.body()).entities().values()) {
                    if (!item.id().equals(this.qNumber)) continue;
                    for (Entities.Label label : item.labels().values()) {
                        if (!label.language().equals(this.langCode)) continue;
                        this.callback.success(label.value());
                        return;
                    }
                }
            }
            this.callback.failure((Throwable)new JsonParseException("Failed to find label for " + this.qNumber + ":" + this.langCode));
        }

        public void onFailure(@NonNull Call<Entities> call, @NonNull Throwable caught) {
            this.callback.failure(caught);
        }
    }

    public static interface LabelCallback {
        public void success(@NonNull String var1);

        public void failure(@NonNull Throwable var1);
    }
}

