/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.search;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.mwapi.MwQueryPage;
import org.wikipedia.model.BaseModel;
import org.wikipedia.page.PageTitle;

public class SearchResult
extends BaseModel
implements Parcelable {
    private PageTitle pageTitle;
    private final String redirectFrom;
    public static final Parcelable.Creator<SearchResult> CREATOR = new Parcelable.Creator<SearchResult>(){

        public SearchResult createFromParcel(Parcel in) {
            return new SearchResult(in);
        }

        public SearchResult[] newArray(int size) {
            return new SearchResult[size];
        }
    };

    public SearchResult(@NonNull MwQueryPage page, @NonNull WikiSite wiki) {
        this(new PageTitle(page.title(), wiki, page.thumbUrl(), page.description()), page.redirectFrom());
    }

    public SearchResult(@NonNull PageTitle pageTitle) {
        this(pageTitle, null);
    }

    public SearchResult(@NonNull PageTitle pageTitle, @Nullable String redirectFrom) {
        this.pageTitle = pageTitle;
        this.redirectFrom = redirectFrom;
    }

    @NonNull
    public PageTitle getPageTitle() {
        return this.pageTitle;
    }

    @Nullable
    public String getRedirectFrom() {
        return this.redirectFrom;
    }

    @Override
    public String toString() {
        return this.pageTitle.getPrefixedText();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable((Parcelable)this.pageTitle, flags);
        parcel.writeString(this.redirectFrom);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)o;
        return other.getPageTitle().equals(this.pageTitle) && TextUtils.equals((CharSequence)other.getRedirectFrom(), (CharSequence)this.redirectFrom);
    }

    @Override
    public int hashCode() {
        int result = this.pageTitle.hashCode();
        result = 31 * result + this.redirectFrom.hashCode();
        return result;
    }

    private SearchResult(Parcel in) {
        this.pageTitle = (PageTitle)in.readParcelable(PageTitle.class.getClassLoader());
        this.redirectFrom = in.readString();
    }
}

