/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.page;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import org.wikipedia.page.Namespace;
import org.wikipedia.page.PageProperties;
import org.wikipedia.page.PageTitle;
import org.wikipedia.page.Section;

public class Page {
    @NonNull
    private final PageTitle title;
    @NonNull
    private final List<Section> sections;
    @NonNull
    private final PageProperties pageProperties;
    private final boolean fromRestBase;

    public Page(@NonNull PageTitle title, @NonNull List<Section> sections, @NonNull PageProperties pageProperties, boolean fromRestBase) {
        this.title = title;
        this.sections = sections;
        this.pageProperties = pageProperties;
        this.fromRestBase = fromRestBase;
    }

    @NonNull
    public PageTitle getTitle() {
        return this.title;
    }

    @NonNull
    public List<Section> getSections() {
        return this.sections;
    }

    public String getDisplayTitle() {
        return this.pageProperties.getDisplayTitle();
    }

    @Nullable
    public String getTitlePronunciationUrl() {
        return this.getPageProperties().getTitlePronunciationUrl();
    }

    @NonNull
    public PageProperties getPageProperties() {
        return this.pageProperties;
    }

    public boolean couldHaveReadMoreSection() {
        return this.getTitle().namespace() == Namespace.MAIN;
    }

    public boolean isFilePage() {
        return this.title.isFilePage();
    }

    public boolean isMainPage() {
        return this.pageProperties.isMainPage();
    }

    public boolean isArticle() {
        return !this.isMainPage() && this.getTitle().namespace() == Namespace.MAIN;
    }

    public boolean isProtected() {
        return !this.getPageProperties().canEdit();
    }

    public boolean isFromRestBase() {
        return this.fromRestBase;
    }
}

