/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.okhttp;

import android.support.annotation.NonNull;
import java.io.IOException;
import java.io.InputStream;

public class AvailableInputStream
extends InputStream {
    private InputStream stream;
    private long available;

    public AvailableInputStream(InputStream stream, long available) {
        this.stream = stream;
        this.available = available;
    }

    @Override
    public int read() throws IOException {
        this.decreaseAvailable(1L);
        return this.stream.read();
    }

    @Override
    public int read(@NonNull byte[] b) throws IOException {
        int ret = this.stream.read(b);
        if (ret > 0) {
            this.decreaseAvailable(ret);
        }
        return ret;
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        int ret = this.stream.read(b, off, len);
        if (ret > 0) {
            this.decreaseAvailable(ret);
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = this.stream.skip(n);
        if (ret > 0L) {
            this.decreaseAvailable(ret);
        }
        return ret;
    }

    @Override
    public int available() throws IOException {
        int ret = this.stream.available();
        if (ret == 0 && this.available > 0L) {
            return (int)this.available;
        }
        return ret;
    }

    private void decreaseAvailable(long n) {
        this.available -= n;
        if (this.available < 0L) {
            this.available = 0L;
        }
    }
}

