/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient;

import android.support.annotation.NonNull;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import com.google.gson.Gson;
import org.wikipedia.AppAdapter;
import org.wikipedia.dataclient.RestService;
import org.wikipedia.dataclient.Service;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.json.GsonUtil;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public final class ServiceFactory {
    private static final int SERVICE_CACHE_SIZE = 8;
    private static LruCache<Long, Service> SERVICE_CACHE = new LruCache(8);
    private static LruCache<Long, RestService> REST_SERVICE_CACHE = new LruCache(8);

    public static Service get(@NonNull WikiSite wiki) {
        long hashCode = wiki.hashCode();
        if (SERVICE_CACHE.get((Object)hashCode) != null) {
            return (Service)SERVICE_CACHE.get((Object)hashCode);
        }
        Retrofit r = ServiceFactory.createRetrofit(wiki, TextUtils.isEmpty((CharSequence)AppAdapter.get().getMediaWikiBaseUrl()) ? wiki.url() + "/" : AppAdapter.get().getMediaWikiBaseUrl());
        Service s = (Service)r.create(Service.class);
        SERVICE_CACHE.put((Object)hashCode, (Object)s);
        return s;
    }

    public static RestService getRest(@NonNull WikiSite wiki) {
        long hashCode = wiki.hashCode();
        if (REST_SERVICE_CACHE.get((Object)hashCode) != null) {
            return (RestService)REST_SERVICE_CACHE.get((Object)hashCode);
        }
        Retrofit r = ServiceFactory.createRetrofit(wiki, TextUtils.isEmpty((CharSequence)AppAdapter.get().getRestbaseUriFormat()) ? wiki.url() + "/" + "api/rest_v1/" : String.format(AppAdapter.get().getRestbaseUriFormat(), "https", wiki.authority()));
        RestService s = (RestService)r.create(RestService.class);
        REST_SERVICE_CACHE.put((Object)hashCode, (Object)s);
        return s;
    }

    private static Retrofit createRetrofit(@NonNull WikiSite wiki, @NonNull String baseUrl) {
        return new Retrofit.Builder().client(AppAdapter.get().getOkHttpClient(wiki)).baseUrl(baseUrl).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GsonUtil.getDefaultGson())).build();
    }

    private ServiceFactory() {
    }
}

