/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.util;

public final class MathUtil {
    private static final int PERCENTAGE_BASE = 100;

    public static float constrain(float f, float min, float max) {
        return Math.min(Math.max(min, f), max);
    }

    public static float percentage(float numerator, float denominator) {
        return numerator / denominator * 100.0f;
    }

    private MathUtil() {
    }

    public static class Averaged<T extends Number> {
        private double sampleSum;
        private int sampleSize;

        public void addSample(T sample) {
            this.sampleSum += ((Number)sample).doubleValue();
            ++this.sampleSize;
        }

        public double getAverage() {
            return this.sampleSize == 0 ? 0.0 : this.sampleSum / (double)this.sampleSize;
        }

        public void reset() {
            this.sampleSum = 0.0;
            this.sampleSize = 0;
        }
    }
}

