/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.page;

import androidx.annotation.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.wikipedia.json.GsonUtil;

public class Section {
    private int id;
    private int toclevel = 1;
    private String line;
    private String anchor;
    private String text;

    public static Section fromJson(JSONObject json) {
        return (Section)GsonUtil.getDefaultGson().fromJson(json.toString(), Section.class);
    }

    public JSONObject toJSON() {
        try {
            JSONObject data = new JSONObject();
            data.put("id", this.id);
            data.put("toclevel", this.toclevel);
            data.put("line", (Object)this.line);
            data.put("anchor", (Object)this.anchor);
            data.put("text", (Object)this.text);
            return data;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Section() {
        this.toclevel = 1;
    }

    public Section(int id, int level, String heading, String anchor, String content) {
        this.id = id;
        this.toclevel = level;
        this.line = heading;
        this.anchor = anchor;
        this.text = content;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Section)) {
            return false;
        }
        Section other = (Section)o;
        return this.getId() == other.getId() && this.getLevel() == other.getLevel() && StringUtils.equals((CharSequence)this.getHeading(), (CharSequence)other.getHeading()) && StringUtils.equals((CharSequence)this.getAnchor(), (CharSequence)other.getAnchor()) && StringUtils.equals((CharSequence)this.getContent(), (CharSequence)other.getContent());
    }

    public int hashCode() {
        int result = this.getId();
        result = 31 * result + this.getHeading().hashCode();
        result = 31 * result + this.getAnchor().hashCode();
        result = 31 * result + this.getContent().hashCode();
        return result;
    }

    public String toString() {
        return "Section{id=" + this.id + ", toclevel=" + this.toclevel + ", line='" + this.line + '\'' + ", anchor='" + this.anchor + '\'' + ", text='" + this.text + '\'' + '}';
    }

    public boolean isLead() {
        return this.id == 0;
    }

    public int getId() {
        return this.id;
    }

    public int getLevel() {
        return this.toclevel;
    }

    @NonNull
    public String getHeading() {
        return StringUtils.defaultString((String)this.line);
    }

    @NonNull
    public String getAnchor() {
        return StringUtils.defaultString((String)this.anchor);
    }

    @NonNull
    public String getContent() {
        return StringUtils.defaultString((String)this.text);
    }
}

