/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.feed.news;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.dataclient.restbase.page.RbPageSummary;
import org.wikipedia.json.annotations.Required;
import org.wikipedia.util.ImageUrlUtil;

public final class NewsItem {
    @Required
    @Nullable
    private String story;
    @Nullable
    private List<RbPageSummary> links = Collections.emptyList();

    @NonNull
    String story() {
        return StringUtils.defaultString((String)this.story);
    }

    @NonNull
    public List<RbPageSummary> links() {
        return this.links != null ? this.links : Collections.emptyList();
    }

    @Nullable
    public Uri thumb() {
        Uri uri = this.getFirstImageUri(this.links());
        return uri != null ? ImageUrlUtil.getUrlForSize(uri, 320) : null;
    }

    @Nullable
    Uri featureImage() {
        return this.getFirstImageUri(this.links());
    }

    @Nullable
    private Uri getFirstImageUri(List<RbPageSummary> links) {
        for (RbPageSummary link : links) {
            String thumbnail;
            if (link == null || (thumbnail = link.getThumbnailUrl()) == null) continue;
            return Uri.parse((String)thumbnail);
        }
        return null;
    }
}

