/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.restbase.page;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.reactivex.Observable;
import okhttp3.CacheControl;
import okhttp3.Request;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.page.PageClient;
import org.wikipedia.dataclient.page.PageSummary;
import org.wikipedia.dataclient.restbase.page.RbPageLead;
import org.wikipedia.dataclient.restbase.page.RbPageRemaining;
import retrofit2.Response;

public class RbPageClient
implements PageClient {
    @NonNull
    public Observable<? extends PageSummary> summary(@NonNull WikiSite wiki, @NonNull String title, @Nullable String referrerUrl) {
        return ServiceFactory.getRest(wiki).getSummary(referrerUrl, title);
    }

    @NonNull
    public Observable<Response<RbPageLead>> lead(@NonNull WikiSite wiki, @Nullable CacheControl cacheControl, @Nullable String saveOfflineHeader, @Nullable String referrerUrl, @NonNull String title, int leadThumbnailWidth) {
        return ServiceFactory.getRest(wiki).getLeadSection(cacheControl == null ? null : cacheControl.toString(), saveOfflineHeader, referrerUrl, title);
    }

    @NonNull
    public Observable<Response<RbPageRemaining>> sections(@NonNull WikiSite wiki, @Nullable CacheControl cacheControl, @Nullable String saveOfflineHeader, @NonNull String title) {
        return ServiceFactory.getRest(wiki).getRemainingSections(cacheControl == null ? null : cacheControl.toString(), saveOfflineHeader, title);
    }

    @Override
    @NonNull
    public Request sectionsUrl(@NonNull WikiSite wiki, @Nullable CacheControl cacheControl, @Nullable String saveOfflineHeader, @NonNull String title) {
        return ServiceFactory.getRest(wiki).getRemainingSectionsUrl(cacheControl == null ? null : cacheControl.toString(), saveOfflineHeader, title).request();
    }
}

