/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import org.wikipedia.page.PageTitle;
import org.wikipedia.util.UriUtil;

public class WikiSite
implements Parcelable {
    public static final String DEFAULT_SCHEME = "https";
    private static String DEFAULT_BASE_URL = "https://wikipedia.org/";
    public static final Parcelable.Creator<WikiSite> CREATOR = new Parcelable.Creator<WikiSite>(){

        public WikiSite createFromParcel(Parcel in) {
            return new WikiSite(in);
        }

        public WikiSite[] newArray(int size) {
            return new WikiSite[size];
        }
    };
    @SerializedName(value="domain")
    @NonNull
    private final Uri uri;
    @NonNull
    private String languageCode;

    public static boolean supportedAuthority(@NonNull String authority) {
        return authority.endsWith(Uri.parse((String)DEFAULT_BASE_URL).getAuthority());
    }

    public static void setDefaultBaseUrl(@NonNull String url) {
        DEFAULT_BASE_URL = TextUtils.isEmpty((CharSequence)url) ? "https://wikipedia.org/" : url;
    }

    public static WikiSite forLanguageCode(@NonNull String languageCode) {
        Uri uri = WikiSite.ensureScheme(Uri.parse((String)DEFAULT_BASE_URL));
        return new WikiSite((languageCode.isEmpty() ? "" : WikiSite.languageCodeToSubdomain(languageCode) + ".") + uri.getAuthority(), languageCode);
    }

    public WikiSite(@NonNull Uri uri) {
        String langVariant;
        Uri tempUri = WikiSite.ensureScheme(uri);
        String authority = tempUri.getAuthority();
        if (("wikipedia.org".equals(authority) || "www.wikipedia.org".equals(authority)) && tempUri.getPath() != null && tempUri.getPath().startsWith("/wiki")) {
            authority = "en.wikipedia.org";
        }
        this.languageCode = !TextUtils.isEmpty((CharSequence)(langVariant = UriUtil.getLanguageVariantFromUri(tempUri))) ? langVariant : WikiSite.authorityToLanguageCode(authority);
        this.uri = new Uri.Builder().scheme(tempUri.getScheme()).encodedAuthority(authority).build();
    }

    public WikiSite(@NonNull String url) {
        this(url.startsWith("http") ? Uri.parse((String)url) : (url.startsWith("//") ? Uri.parse((String)("https:" + url)) : Uri.parse((String)("https://" + url))));
    }

    public WikiSite(@NonNull String authority, @NonNull String languageCode) {
        this(authority);
        this.languageCode = languageCode;
    }

    @NonNull
    public String scheme() {
        return TextUtils.isEmpty((CharSequence)this.uri.getScheme()) ? DEFAULT_SCHEME : this.uri.getScheme();
    }

    @NonNull
    public String authority() {
        return this.uri.getAuthority();
    }

    @NonNull
    public String mobileAuthority() {
        return this.authorityToMobile(this.authority());
    }

    @NonNull
    public String desktopAuthority() {
        return this.authority().replace(".m.", ".");
    }

    @NonNull
    public String subdomain() {
        return WikiSite.languageCodeToSubdomain(this.languageCode);
    }

    @NonNull
    public String path(@NonNull String segment) {
        return "/w/" + segment;
    }

    @NonNull
    public Uri uri() {
        return this.uri;
    }

    @NonNull
    public String url() {
        return this.uri.toString();
    }

    @NonNull
    public String url(@NonNull String segment) {
        return this.url() + this.path(segment);
    }

    @NonNull
    public String languageCode() {
        return this.languageCode;
    }

    public PageTitle titleForInternalLink(String internalLink) {
        return new PageTitle(UriUtil.removeInternalLinkPrefix(internalLink), this);
    }

    public PageTitle titleForUri(Uri uri) {
        String path = uri.getPath();
        if (!TextUtils.isEmpty((CharSequence)uri.getFragment())) {
            path = path + "#" + uri.getFragment();
        }
        return this.titleForInternalLink(path);
    }

    @NonNull
    public String dbName() {
        return this.subdomain().replaceAll("-", "_") + "wiki";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WikiSite wiki = (WikiSite)o;
        if (!this.uri.equals((Object)wiki.uri)) {
            return false;
        }
        return this.languageCode.equals(wiki.languageCode);
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = 31 * result + this.languageCode.hashCode();
        return result;
    }

    public String toString() {
        return "WikiSite{uri=" + this.uri + ", languageCode='" + this.languageCode + '\'' + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.uri, 0);
        dest.writeString(this.languageCode);
    }

    protected WikiSite(@NonNull Parcel in) {
        this.uri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.languageCode = in.readString();
    }

    @NonNull
    private static String languageCodeToSubdomain(@NonNull String languageCode) {
        switch (languageCode) {
            case "zh-hans": 
            case "zh-hant": 
            case "zh-cn": 
            case "zh-hk": 
            case "zh-mo": 
            case "zh-sg": 
            case "zh-tw": {
                return "zh";
            }
            case "nb": {
                return "no";
            }
        }
        return languageCode;
    }

    @NonNull
    private static String authorityToLanguageCode(@NonNull String authority) {
        String[] parts = authority.split("\\.");
        int minLengthForSubdomain = 3;
        if (parts.length < 3 || parts.length == 3 && parts[0].equals("m")) {
            return "";
        }
        return parts[0];
    }

    @NonNull
    private static Uri ensureScheme(@NonNull Uri uri) {
        if (TextUtils.isEmpty((CharSequence)uri.getScheme())) {
            return uri.buildUpon().scheme(DEFAULT_SCHEME).build();
        }
        return uri;
    }

    @NonNull
    private String authorityToMobile(@NonNull String authority) {
        if (authority.startsWith("m.") || authority.contains(".m.")) {
            return authority;
        }
        return authority.replaceFirst("^" + this.subdomain() + "\\.?", "$0m.");
    }
}

