/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.okhttp;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import okhttp3.Response;
import org.wikipedia.dataclient.ServiceError;
import org.wikipedia.dataclient.restbase.RbServiceError;
import org.wikipedia.util.log.L;

public class HttpStatusException
extends IOException {
    private final int code;
    private final String url;
    @Nullable
    private ServiceError serviceError;

    public HttpStatusException(@NonNull Response rsp) {
        this.code = rsp.code();
        this.url = rsp.request().url().uri().toString();
        try {
            if (rsp.body() != null && rsp.body().contentType() != null && rsp.body().contentType().toString().contains("json")) {
                this.serviceError = RbServiceError.create(rsp.body().string());
            }
        }
        catch (Exception e) {
            L.e(e);
        }
    }

    public HttpStatusException(@Nullable ServiceError error) {
        this.serviceError = error;
        this.code = 0;
        this.url = "";
    }

    public int code() {
        return this.code;
    }

    public ServiceError serviceError() {
        return this.serviceError;
    }

    @Override
    public String getMessage() {
        String str = "Code: " + Integer.toString(this.code) + ", URL: " + this.url;
        if (this.serviceError != null) {
            str = str + ", title: " + this.serviceError.getTitle() + ", detail: " + this.serviceError.getDetails();
        }
        return str;
    }
}

