/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.mwapi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.mwapi.EditorTaskCounts;
import org.wikipedia.dataclient.mwapi.ImageDetails;
import org.wikipedia.dataclient.mwapi.ListUserResponse;
import org.wikipedia.dataclient.mwapi.MwAuthManagerInfo;
import org.wikipedia.dataclient.mwapi.MwQueryPage;
import org.wikipedia.dataclient.mwapi.NearbyPage;
import org.wikipedia.dataclient.mwapi.RecentChange;
import org.wikipedia.dataclient.mwapi.UserInfo;
import org.wikipedia.gallery.ImageInfo;
import org.wikipedia.gallery.VideoInfo;
import org.wikipedia.json.PostProcessingTypeAdapter;
import org.wikipedia.model.BaseModel;
import org.wikipedia.notifications.Notification;
import org.wikipedia.page.PageTitle;
import org.wikipedia.settings.SiteInfo;

public class MwQueryResult
extends BaseModel
implements PostProcessingTypeAdapter.PostProcessable {
    @Nullable
    private List<MwQueryPage> pages;
    @Nullable
    private List<Redirect> redirects;
    @Nullable
    private List<ConvertedTitle> converted;
    @SerializedName(value="userinfo")
    private UserInfo userInfo;
    @Nullable
    private List<ListUserResponse> users;
    @Nullable
    private Tokens tokens;
    @SerializedName(value="authmanagerinfo")
    @Nullable
    private MwAuthManagerInfo amInfo;
    @Nullable
    private MarkReadResponse echomarkread;
    @Nullable
    private MarkReadResponse echomarkseen;
    @Nullable
    private NotificationList notifications;
    @Nullable
    private Map<String, Notification.UnreadNotificationWikiItem> unreadnotificationpages;
    @SerializedName(value="general")
    @Nullable
    private SiteInfo generalSiteInfo;
    @Nullable
    private List<RecentChange> recentchanges;
    @SerializedName(value="wikimediaeditortaskscounts")
    @Nullable
    private EditorTaskCounts editorTaskCounts;
    @SerializedName(value="allimages")
    @Nullable
    private List<ImageDetails> allImages;

    @Nullable
    public List<MwQueryPage> pages() {
        return this.pages;
    }

    @Nullable
    public MwQueryPage firstPage() {
        if (this.pages != null && this.pages.size() > 0) {
            return this.pages.get(0);
        }
        return null;
    }

    @NonNull
    public List<ImageDetails> allImages() {
        return this.allImages == null ? Collections.emptyList() : this.allImages;
    }

    @Nullable
    public UserInfo userInfo() {
        return this.userInfo;
    }

    @Nullable
    public String csrfToken() {
        return this.tokens != null ? this.tokens.csrf() : null;
    }

    @Nullable
    public String createAccountToken() {
        return this.tokens != null ? this.tokens.createAccount() : null;
    }

    @Nullable
    public String loginToken() {
        return this.tokens != null ? this.tokens.login() : null;
    }

    @Nullable
    public NotificationList notifications() {
        return this.notifications;
    }

    @Nullable
    public Map<String, Notification.UnreadNotificationWikiItem> unreadNotificationWikis() {
        return this.unreadnotificationpages;
    }

    @Nullable
    public MarkReadResponse getEchoMarkSeen() {
        return this.echomarkseen;
    }

    @Nullable
    public String captchaId() {
        String captchaId = null;
        if (this.amInfo != null) {
            for (MwAuthManagerInfo.Request request : this.amInfo.requests()) {
                if (!"CaptchaAuthenticationRequest".equals(request.id())) continue;
                captchaId = request.fields().get("captchaId").value();
            }
        }
        return captchaId;
    }

    @Nullable
    public List<RecentChange> getRecentChanges() {
        return this.recentchanges;
    }

    @Nullable
    public ListUserResponse getUserResponse(@NonNull String userName) {
        if (this.users != null) {
            for (ListUserResponse user : this.users) {
                if (!StringUtils.capitalize((String)userName).equals(user.name())) continue;
                return user;
            }
        }
        return null;
    }

    @NonNull
    public Map<String, ImageInfo> images() {
        HashMap<String, ImageInfo> result = new HashMap<String, ImageInfo>();
        if (this.pages != null) {
            for (MwQueryPage page : this.pages) {
                if (page.imageInfo() == null) continue;
                result.put(page.title(), page.imageInfo());
            }
        }
        return result;
    }

    @NonNull
    public Map<String, VideoInfo> videos() {
        HashMap<String, VideoInfo> result = new HashMap<String, VideoInfo>();
        if (this.pages != null) {
            for (MwQueryPage page : this.pages) {
                if (page.videoInfo() == null) continue;
                result.put(page.title(), page.videoInfo());
            }
        }
        return result;
    }

    @NonNull
    public List<PageTitle> langLinks() {
        ArrayList<PageTitle> result = new ArrayList<PageTitle>();
        if (this.pages == null || this.pages.isEmpty() || this.pages.get(0).langLinks() == null) {
            return result;
        }
        for (MwQueryPage.LangLink link : this.pages.get(0).langLinks()) {
            PageTitle title = new PageTitle(link.title(), WikiSite.forLanguageCode(link.lang()));
            result.add(title);
        }
        return result;
    }

    @NonNull
    public List<NearbyPage> nearbyPages(@NonNull WikiSite wiki) {
        ArrayList<NearbyPage> result = new ArrayList<NearbyPage>();
        if (this.pages != null) {
            for (MwQueryPage page : this.pages) {
                NearbyPage nearbyPage = new NearbyPage(page, wiki);
                if (nearbyPage.getLocation() == null) continue;
                result.add(nearbyPage);
            }
        }
        return result;
    }

    @Nullable
    public SiteInfo siteInfo() {
        return this.generalSiteInfo;
    }

    @Nullable
    public EditorTaskCounts editorTaskCounts() {
        return this.editorTaskCounts;
    }

    @Override
    public void postProcess() {
        this.resolveConvertedTitles();
        this.resolveRedirectedTitles();
    }

    private void resolveRedirectedTitles() {
        if (this.redirects == null || this.pages == null) {
            return;
        }
        for (MwQueryPage page : this.pages) {
            for (Redirect redirect : this.redirects) {
                if (!page.title().equals(redirect.to())) continue;
                page.redirectFrom(redirect.from());
                if (redirect.toFragment() == null) continue;
                page.appendTitleFragment(redirect.toFragment());
            }
        }
    }

    private void resolveConvertedTitles() {
        if (this.converted == null || this.pages == null) {
            return;
        }
        for (ConvertedTitle convertedTitle : this.converted) {
            for (MwQueryPage page : this.pages) {
                if (!page.title().equals(convertedTitle.to())) continue;
                page.convertedFrom(convertedTitle.from());
                page.convertedTo(convertedTitle.to());
            }
        }
    }

    public static class NotificationList {
        private int count;
        private int rawcount;
        @Nullable
        private Notification.SeenTime seenTime;
        @Nullable
        private List<Notification> list;
        @SerializedName(value="continue")
        @Nullable
        private String continueStr;

        @Nullable
        public List<Notification> list() {
            return this.list;
        }

        @Nullable
        public String getContinue() {
            return this.continueStr;
        }

        public int getCount() {
            return this.count;
        }

        @Nullable
        public Notification.SeenTime getSeenTime() {
            return this.seenTime;
        }
    }

    public static class MarkReadResponse {
        @Nullable
        private String result;
        @Nullable
        private String timestamp;

        @Nullable
        public String getResult() {
            return this.result;
        }

        @Nullable
        public String getTimestamp() {
            return this.timestamp;
        }
    }

    private static class Tokens {
        @SerializedName(value="csrftoken")
        @Nullable
        private String csrf;
        @SerializedName(value="createaccounttoken")
        @Nullable
        private String createAccount;
        @SerializedName(value="logintoken")
        @Nullable
        private String login;

        private Tokens() {
        }

        @Nullable
        private String csrf() {
            return this.csrf;
        }

        @Nullable
        private String createAccount() {
            return this.createAccount;
        }

        @Nullable
        private String login() {
            return this.login;
        }
    }

    public static class ConvertedTitle {
        @Nullable
        private String from;
        @Nullable
        private String to;

        @Nullable
        public String to() {
            return this.to;
        }

        @Nullable
        public String from() {
            return this.from;
        }
    }

    private static class Redirect {
        private int index;
        @Nullable
        private String from;
        @Nullable
        private String to;
        @SerializedName(value="tofragment")
        @Nullable
        private String toFragment;

        private Redirect() {
        }

        @Nullable
        public String to() {
            return this.to;
        }

        @Nullable
        public String from() {
            return this.from;
        }

        @Nullable
        public String toFragment() {
            return this.toFragment;
        }
    }
}

