/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.mwapi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wikipedia.json.GsonUtil;

public class EditorTaskCounts {
    @Nullable
    private JsonElement counts;
    @SerializedName(value="targets_passed")
    @Nullable
    private JsonElement targetsPassed;
    @Nullable
    private JsonElement targets;

    @NonNull
    public Map<String, Integer> getDescriptionEditsPerLanguage() {
        Map editsPerLanguage = null;
        if (this.counts != null && !(this.counts instanceof JsonArray)) {
            editsPerLanguage = ((Counts)GsonUtil.getDefaultGson().fromJson(this.counts, Counts.class)).appDescriptionEdits;
        }
        return editsPerLanguage == null ? Collections.emptyMap() : editsPerLanguage;
    }

    @NonNull
    public List<Integer> getDescriptionEditTargetsPassed() {
        List passedList = null;
        if (this.targetsPassed != null && !(this.targetsPassed instanceof JsonArray)) {
            passedList = ((Targets)GsonUtil.getDefaultGson().fromJson(this.targetsPassed, Targets.class)).appDescriptionEdits;
        }
        return passedList == null ? Collections.emptyList() : passedList;
    }

    public int getDescriptionEditTargetsPassedCount() {
        List<Integer> targetList = this.getDescriptionEditTargets();
        List<Integer> passedList = this.getDescriptionEditTargetsPassed();
        int count = 0;
        if (!targetList.isEmpty() && !passedList.isEmpty()) {
            for (int target : targetList) {
                if (!passedList.contains(target)) continue;
                ++count;
            }
        }
        return count;
    }

    @NonNull
    public List<Integer> getDescriptionEditTargets() {
        List targetList = null;
        if (this.targets != null && !(this.targets instanceof JsonArray)) {
            targetList = ((Targets)GsonUtil.getDefaultGson().fromJson(this.targets, Targets.class)).appDescriptionEdits;
        }
        return targetList == null ? Collections.emptyList() : targetList;
    }

    @NonNull
    public Map<String, Integer> getCaptionEditsPerLanguage() {
        Map editsPerLanguage = null;
        if (this.counts != null && !(this.counts instanceof JsonArray)) {
            editsPerLanguage = ((Counts)GsonUtil.getDefaultGson().fromJson(this.counts, Counts.class)).appCaptionEdits;
        }
        return editsPerLanguage == null ? Collections.emptyMap() : editsPerLanguage;
    }

    @NonNull
    public List<Integer> getCaptionEditTargetsPassed() {
        List passedList = null;
        if (this.targetsPassed != null && !(this.targetsPassed instanceof JsonArray)) {
            passedList = ((Targets)GsonUtil.getDefaultGson().fromJson(this.targetsPassed, Targets.class)).appCaptionEdits;
        }
        return passedList == null ? Collections.emptyList() : passedList;
    }

    public int getCaptionEditTargetsPassedCount() {
        List<Integer> targetList = this.getCaptionEditTargets();
        List<Integer> passedList = this.getCaptionEditTargetsPassed();
        int count = 0;
        if (!targetList.isEmpty() && !passedList.isEmpty()) {
            for (int target : targetList) {
                if (!passedList.contains(target)) continue;
                ++count;
            }
        }
        return count;
    }

    @NonNull
    public List<Integer> getCaptionEditTargets() {
        List targetList = null;
        if (this.targets != null && !(this.targets instanceof JsonArray)) {
            targetList = ((Targets)GsonUtil.getDefaultGson().fromJson(this.targets, Targets.class)).appCaptionEdits;
        }
        return targetList == null ? Collections.emptyList() : targetList;
    }

    public class Targets {
        @SerializedName(value="app_description_edits")
        @Nullable
        private List<Integer> appDescriptionEdits;
        @SerializedName(value="app_caption_edits")
        @Nullable
        private List<Integer> appCaptionEdits;
    }

    public class Counts {
        @SerializedName(value="app_description_edits")
        @Nullable
        private Map<String, Integer> appDescriptionEdits;
        @SerializedName(value="app_caption_edits")
        @Nullable
        private Map<String, Integer> appCaptionEdits;
    }
}

