/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.wikidata;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.dataclient.mwapi.MwResponse;
import org.wikipedia.json.PostProcessingTypeAdapter;

public class Entities
extends MwResponse
implements PostProcessingTypeAdapter.PostProcessable {
    @Nullable
    private Map<String, Entity> entities;
    private int success;

    @Nullable
    public Map<String, Entity> entities() {
        return this.entities;
    }

    @Nullable
    public Entity getFirst() {
        if (this.entities == null) {
            return null;
        }
        return this.entities.values().iterator().next();
    }

    @Override
    public void postProcess() {
        if (this.getFirst() != null && this.getFirst().isMissing()) {
            throw new RuntimeException("The requested entity was not found.");
        }
    }

    public static class SiteLink {
        @Nullable
        private String site;
        @Nullable
        private String title;

        @NonNull
        public String getSite() {
            return StringUtils.defaultString((String)this.site);
        }

        @NonNull
        public String getTitle() {
            return StringUtils.defaultString((String)this.title);
        }
    }

    public static class Label {
        @Nullable
        private String language;
        @Nullable
        private String value;

        @NonNull
        public String language() {
            return StringUtils.defaultString((String)this.language);
        }

        @NonNull
        public String value() {
            return StringUtils.defaultString((String)this.value);
        }
    }

    public static class Entity {
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private Map<String, Label> labels;
        @Nullable
        private Map<String, Label> descriptions;
        @Nullable
        private Map<String, SiteLink> sitelinks;
        @Nullable
        private String missing;

        @NonNull
        public String id() {
            return StringUtils.defaultString((String)this.id);
        }

        @NonNull
        public Map<String, Label> labels() {
            return this.labels != null ? this.labels : Collections.emptyMap();
        }

        @NonNull
        public Map<String, Label> descriptions() {
            return this.descriptions != null ? this.descriptions : Collections.emptyMap();
        }

        @NonNull
        public Map<String, SiteLink> sitelinks() {
            return this.sitelinks != null ? this.sitelinks : Collections.emptyMap();
        }

        boolean isMissing() {
            return "-1".equals(this.id) && this.missing != null;
        }
    }
}

