/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.reactivex.Observable;
import org.wikipedia.captcha.Captcha;
import org.wikipedia.dataclient.mwapi.CreateAccountResponse;
import org.wikipedia.dataclient.mwapi.MwPostResponse;
import org.wikipedia.dataclient.mwapi.MwQueryResponse;
import org.wikipedia.dataclient.mwapi.SiteMatrix;
import org.wikipedia.dataclient.mwapi.page.MwMobileViewPageLead;
import org.wikipedia.dataclient.mwapi.page.MwMobileViewPageRemaining;
import org.wikipedia.dataclient.mwapi.page.MwQueryPageSummary;
import org.wikipedia.edit.Edit;
import org.wikipedia.edit.preview.EditPreview;
import org.wikipedia.login.LoginClient;
import org.wikipedia.search.PrefixSearchResponse;
import org.wikipedia.wikidata.Entities;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface Service {
    public static final String WIKIPEDIA_URL = "https://wikipedia.org/";
    public static final String WIKIDATA_URL = "https://www.wikidata.org/";
    public static final String COMMONS_URL = "https://commons.wikimedia.org/";
    public static final String META_URL = "https://meta.wikimedia.org/";
    public static final String MW_API_PREFIX = "w/api.php?format=json&formatversion=2&errorformat=plaintext&";
    public static final String MW_PAGE_SECTIONS_URL = "w/api.php?format=json&formatversion=2&errorformat=plaintext&action=mobileview&prop=text|sections&onlyrequestedsections=1&sections=1-&sectionprop=toclevel|line|anchor&noheadings=";
    public static final int PREFERRED_THUMB_SIZE = 320;
    public static final String OFFLINE_SAVE_HEADER = "X-Offline-Save";
    public static final String OFFLINE_SAVE_HEADER_SAVE = "save";
    public static final String OFFLINE_SAVE_HEADER_DELETE = "delete";
    public static final String OFFLINE_SAVE_HEADER_NONE = "none";

    @Headers(value={"x-analytics: preview=1"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&redirects=&converttitles=&prop=extracts|pageimages|pageprops&exsentences=5&piprop=thumbnail|name&pilicense=any&explaintext=&pithumbsize=320")
    @NonNull
    public Observable<MwQueryPageSummary> getSummary(@Header(value="Referer") @Nullable String var1, @Query(value="titles") @NonNull String var2, @Query(value="uselang") @Nullable String var3);

    @Headers(value={"x-analytics: pageview=1"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=mobileview&prop=text|sections|languagecount|thumb|image|id|namespace|revision|description|lastmodified|normalizedtitle|displaytitle|protection|editable|pageprops&pageprops=wikibase_item&sections=0&sectionprop=toclevel|line|anchor&noheadings=")
    @NonNull
    public Observable<Response<MwMobileViewPageLead>> getLeadSection(@Header(value="Cache-Control") @Nullable String var1, @Header(value="X-Offline-Save") @Nullable String var2, @Header(value="Referer") @Nullable String var3, @Query(value="page") @NonNull String var4, @Query(value="thumbwidth") int var5, @Query(value="uselang") @Nullable String var6);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=mobileview&prop=text|sections&onlyrequestedsections=1&sections=1-&sectionprop=toclevel|line|anchor&noheadings=")
    @NonNull
    public Observable<Response<MwMobileViewPageRemaining>> getRemainingSections(@Header(value="Cache-Control") @Nullable String var1, @Header(value="X-Offline-Save") @Nullable String var2, @Query(value="page") @NonNull String var3, @Query(value="uselang") @Nullable String var4);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=mobileview&prop=text|sections&onlyrequestedsections=1&sections=1-&sectionprop=toclevel|line|anchor&noheadings=")
    @NonNull
    public Call<MwMobileViewPageRemaining> getRemainingSectionsUrl(@Header(value="Cache-Control") @Nullable String var1, @Header(value="X-Offline-Save") @Nullable String var2, @Query(value="page") @NonNull String var3, @Query(value="uselang") @Nullable String var4);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&prop=pageimages&piprop=thumbnail&converttitles=&pilicense=any&pithumbsize=320")
    @NonNull
    public Observable<MwQueryResponse> getPageImages(@Query(value="titles") @NonNull String var1);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&redirects=&converttitles=&prop=description|pageimages&piprop=thumbnail&pilicense=any&generator=prefixsearch&gpsnamespace=0&list=search&srnamespace=0&srwhat=text&srinfo=suggestion&srprop=&sroffset=0&srlimit=1&pithumbsize=320")
    @NonNull
    public Observable<PrefixSearchResponse> prefixSearch(@Query(value="gpssearch") String var1, @Query(value="gpslimit") int var2, @Query(value="srsearch") String var3);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&converttitles=&prop=description|pageimages|pageprops&ppprop=mainpage|disambiguation&generator=search&gsrnamespace=0&gsrwhat=text&gsrinfo=&gsrprop=redirecttitle&piprop=thumbnail&pilicense=any&pithumbsize=320")
    @NonNull
    public Observable<MwQueryResponse> fullTextSearch(@Query(value="gsrsearch") String var1, @Query(value="gsrlimit") int var2, @Query(value="continue") String var3, @Query(value="gsroffset") String var4);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&prop=coordinates|description|pageimages&colimit=50&piprop=thumbnail&pilicense=any&generator=geosearch&ggslimit=50&pithumbsize=320")
    @NonNull
    public Observable<MwQueryResponse> nearbySearch(@Query(value="ggscoord") @NonNull String var1, @Query(value="ggsradius") double var2);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=fancycaptchareload")
    @NonNull
    public Observable<Captcha> getNewCaptcha();

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&prop=langlinks&lllimit=500&redirects=&converttitles=")
    @NonNull
    public Observable<MwQueryResponse> getLangLinks(@Query(value="titles") @NonNull String var1);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&prop=description|pageprops&redirects")
    @NonNull
    public Observable<MwQueryResponse> getPagePropsAndDescription(@Query(value="titles") @NonNull String var1);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&prop=description")
    @NonNull
    public Observable<MwQueryResponse> getDescription(@Query(value="titles") @NonNull String var1);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&prop=imageinfo&iiprop=timestamp|user|url|extmetadata&iiurlwidth=320")
    @NonNull
    public Observable<MwQueryResponse> getImageExtMetadata(@Query(value="titles") @NonNull String var1);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=sitematrix&smtype=language&smlangprop=code|name|localname")
    @NonNull
    public Observable<SiteMatrix> getSiteMatrix();

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=siteinfo")
    @NonNull
    public Observable<MwQueryResponse> getSiteInfo();

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&generator=random&redirects=1&grnnamespace=0&grnlimit=50&prop=pageprops|description")
    @NonNull
    public Observable<MwQueryResponse> getRandomWithPageProps();

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&generator=random&redirects=1&grnnamespace=6&grnlimit=50&prop=description|imageinfo&iiprop=timestamp|user|url|mime&iiurlwidth=320")
    @NonNull
    public Observable<MwQueryResponse> getRandomWithImageInfo();

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&prop=categories&clprop=hidden&cllimit=500")
    @NonNull
    public Observable<MwQueryResponse> getCategories(@Query(value="titles") @NonNull String var1);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&list=categorymembers&cmlimit=500")
    @NonNull
    public Observable<MwQueryResponse> getCategoryMembers(@Query(value="cmtitle") @NonNull String var1, @Query(value="cmcontinue") @Nullable String var2);

    @FormUrlEncoded
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=thank")
    @NonNull
    public Observable<MwPostResponse> thank(@Field(value="rev") @Nullable String var1, @Field(value="log") @Nullable String var2, @Field(value="token") @NonNull String var3, @Field(value="source") @Nullable String var4);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=tokens&type=csrf")
    @NonNull
    public Call<MwQueryResponse> getCsrfTokenCall();

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=tokens&type=csrf")
    @NonNull
    public Observable<MwQueryResponse> getCsrfToken();

    @FormUrlEncoded
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=createaccount&createmessageformat=html")
    @NonNull
    public Observable<CreateAccountResponse> postCreateAccount(@Field(value="username") @NonNull String var1, @Field(value="password") @NonNull String var2, @Field(value="retype") @NonNull String var3, @Field(value="createtoken") @NonNull String var4, @Field(value="createreturnurl") @NonNull String var5, @Field(value="email") @Nullable String var6, @Field(value="captchaId") @Nullable String var7, @Field(value="captchaWord") @Nullable String var8);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=tokens&type=login")
    @NonNull
    public Call<MwQueryResponse> getLoginToken();

    @Headers(value={"Cache-Control: no-cache"})
    @FormUrlEncoded
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=clientlogin&rememberMe=")
    @NonNull
    public Call<LoginClient.LoginResponse> postLogIn(@Field(value="username") String var1, @Field(value="password") String var2, @Field(value="logintoken") String var3, @Field(value="loginreturnurl") String var4);

    @Headers(value={"Cache-Control: no-cache"})
    @FormUrlEncoded
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=clientlogin&rememberMe=")
    @NonNull
    public Call<LoginClient.LoginResponse> postLogIn(@Field(value="username") String var1, @Field(value="password") String var2, @Field(value="retype") String var3, @Field(value="OATHToken") String var4, @Field(value="logintoken") String var5, @Field(value="logincontinue") boolean var6);

    @Headers(value={"Cache-Control: no-cache"})
    @FormUrlEncoded
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=logout")
    @NonNull
    public Observable<MwPostResponse> postLogout(@Field(value="token") @NonNull String var1);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=authmanagerinfo|tokens&amirequestsfor=create&type=createaccount")
    @NonNull
    public Observable<MwQueryResponse> getAuthManagerInfo();

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=userinfo&list=users&usprop=groups|cancreate")
    @NonNull
    public Observable<MwQueryResponse> getUserInfo(@Query(value="ususers") @NonNull String var1);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=notifications&notformat=model&notlimit=max")
    @NonNull
    public Observable<MwQueryResponse> getAllNotifications(@Query(value="notwikis") @Nullable String var1, @Query(value="notfilter") @Nullable String var2, @Query(value="notcontinue") @Nullable String var3);

    @FormUrlEncoded
    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=echomarkread")
    @NonNull
    public Observable<MwQueryResponse> markRead(@Field(value="token") @NonNull String var1, @Field(value="list") @Nullable String var2, @Field(value="unreadlist") @Nullable String var3);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=notifications&notprop=list&notfilter=!read&notlimit=1")
    @NonNull
    public Observable<MwQueryResponse> getLastUnreadNotification();

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=unreadnotificationpages&unplimit=max&unpwikis=*")
    @NonNull
    public Observable<MwQueryResponse> getUnreadNotificationWikis();

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=userinfo&uiprop=options")
    @NonNull
    public Observable<MwQueryResponse> getUserOptions();

    @FormUrlEncoded
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=options")
    @NonNull
    public Observable<MwPostResponse> postUserOption(@Field(value="token") @NonNull String var1, @Query(value="optionname") @NonNull String var2, @Query(value="optionvalue") @Nullable String var3);

    @FormUrlEncoded
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=options")
    @NonNull
    public Observable<MwPostResponse> deleteUserOption(@Field(value="token") @NonNull String var1, @Query(value="change") @NonNull String var2);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&prop=revisions&rvprop=content|timestamp&rvlimit=1&converttitles=")
    @NonNull
    public Observable<MwQueryResponse> getWikiTextForSection(@Query(value="titles") @NonNull String var1, @Query(value="rvsection") int var2);

    @FormUrlEncoded
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=parse&prop=text&sectionpreview=&pst=&mobileformat=")
    @NonNull
    public Observable<EditPreview> postEditPreview(@Field(value="title") @NonNull String var1, @Field(value="text") @NonNull String var2);

    @FormUrlEncoded
    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=edit&nocreate=")
    @NonNull
    public Call<Edit> postEditSubmit(@Field(value="title") @NonNull String var1, @Field(value="section") @Nullable Integer var2, @Field(value="summary") @NonNull String var3, @Field(value="assert") @Nullable String var4, @Field(value="text") @NonNull String var5, @Field(value="basetimestamp") @Nullable String var6, @Field(value="token") @NonNull String var7, @Field(value="captchaid") @Nullable String var8, @Field(value="captchaword") @Nullable String var9);

    @FormUrlEncoded
    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=edit&nocreate=")
    @NonNull
    public Observable<Edit> postAppendEdit(@Field(value="title") @NonNull String var1, @Field(value="summary") @NonNull String var2, @Field(value="appendtext") @NonNull String var3, @Field(value="token") @NonNull String var4);

    @FormUrlEncoded
    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=edit&nocreate=")
    @NonNull
    public Observable<Edit> postPrependEdit(@Field(value="title") @NonNull String var1, @Field(value="summary") @NonNull String var2, @Field(value="prependtext") @NonNull String var3, @Field(value="token") @NonNull String var4);

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=tag")
    @FormUrlEncoded
    public Observable<MwPostResponse> addEditTag(@Field(value="revid") @NonNull String var1, @Field(value="add") @NonNull String var2, @Field(value="reason") @NonNull String var3, @Field(value="token") @NonNull String var4);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&meta=wikimediaeditortaskscounts")
    @NonNull
    public Observable<MwQueryResponse> getEditorTaskCounts();

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&generator=wikimediaeditortaskssuggestions&prop=pageprops&gwetstask=missingdescriptions&gwetslimit=3")
    @NonNull
    public Observable<MwQueryResponse> getEditorTaskMissingDescriptions(@Query(value="gwetstarget") @NonNull String var1);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=query&generator=wikimediaeditortaskssuggestions&prop=pageprops&gwetstask=descriptiontranslations&gwetslimit=3")
    @NonNull
    public Observable<MwQueryResponse> getEditorTaskTranslatableDescriptions(@Query(value="gwetssource") @NonNull String var1, @Query(value="gwetstarget") @NonNull String var2);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=wbgetentities")
    @NonNull
    public Observable<Entities> getEntitiesByTitle(@Query(value="titles") @NonNull String var1, @Query(value="sites") @NonNull String var2);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=wbgetentities&props=labels&languagefallback=1")
    @NonNull
    public Call<Entities> getWikidataLabels(@Query(value="ids") @NonNull String var1, @Query(value="languages") @NonNull String var2);

    @GET(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=wbgetentities&props=descriptions|labels|sitelinks")
    @NonNull
    public Observable<Entities> getWikidataLabelsAndDescriptions(@Query(value="ids") @NonNull String var1);

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=wbsetdescription&errorlang=uselang")
    @FormUrlEncoded
    public Observable<MwPostResponse> postDescriptionEdit(@Field(value="language") @NonNull String var1, @Field(value="uselang") @NonNull String var2, @Field(value="site") @NonNull String var3, @Field(value="title") @NonNull String var4, @Field(value="value") @NonNull String var5, @Field(value="summary") @Nullable String var6, @Field(value="token") @NonNull String var7, @Field(value="assert") @Nullable String var8);

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=wbsetlabel&errorlang=uselang")
    @FormUrlEncoded
    public Observable<MwPostResponse> postLabelEdit(@Field(value="language") @NonNull String var1, @Field(value="uselang") @NonNull String var2, @Field(value="site") @NonNull String var3, @Field(value="title") @NonNull String var4, @Field(value="value") @NonNull String var5, @Field(value="summary") @Nullable String var6, @Field(value="token") @NonNull String var7, @Field(value="assert") @Nullable String var8);

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="w/api.php?format=json&formatversion=2&errorformat=plaintext&action=wbcreateclaim&errorlang=uselang")
    @FormUrlEncoded
    public Observable<MwPostResponse> postCreateClaim(@Field(value="entity") @NonNull String var1, @Field(value="snaktype") @NonNull String var2, @Field(value="property") @NonNull String var3, @Field(value="value") @NonNull String var4, @Field(value="uselang") @NonNull String var5, @Field(value="token") @NonNull String var6);
}

