/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.page;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.List;
import org.wikipedia.page.Namespace;
import org.wikipedia.page.PageProperties;
import org.wikipedia.page.PageTitle;
import org.wikipedia.page.Section;

public class Page {
    @VisibleForTesting
    static final int MEDIAWIKI_ORIGIN = 0;
    @VisibleForTesting
    static final int RESTBASE_ORIGIN = 1;
    @NonNull
    private final PageTitle title;
    @NonNull
    private final List<Section> sections;
    @NonNull
    private final PageProperties pageProperties;

    public Page(@NonNull PageTitle title, @NonNull List<Section> sections, @NonNull PageProperties pageProperties) {
        this.title = title;
        this.sections = sections;
        this.pageProperties = pageProperties;
    }

    @NonNull
    public PageTitle getTitle() {
        return this.title;
    }

    @NonNull
    public List<Section> getSections() {
        return this.sections;
    }

    public String getDisplayTitle() {
        return this.pageProperties.getDisplayTitle();
    }

    @Nullable
    public String getTitlePronunciationUrl() {
        return this.getPageProperties().getTitlePronunciationUrl();
    }

    @NonNull
    public PageProperties getPageProperties() {
        return this.pageProperties;
    }

    public boolean couldHaveReadMoreSection() {
        return this.getTitle().namespace() == Namespace.MAIN;
    }

    public boolean isFilePage() {
        return this.title.isFilePage();
    }

    public boolean isMainPage() {
        return this.pageProperties.isMainPage();
    }

    public boolean isArticle() {
        return !this.isMainPage() && this.getTitle().namespace() == Namespace.MAIN;
    }

    public boolean isProtected() {
        return !this.getPageProperties().canEdit();
    }
}

