/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.login;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.mwapi.ListUserResponse;
import org.wikipedia.dataclient.mwapi.MwQueryResponse;
import org.wikipedia.dataclient.mwapi.MwServiceError;
import org.wikipedia.login.LoginOAuthResult;
import org.wikipedia.login.LoginResetPasswordResult;
import org.wikipedia.login.LoginResult;
import org.wikipedia.util.log.L;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LoginClient {
    @Nullable
    private Call<MwQueryResponse> tokenCall;
    @Nullable
    private Call<LoginResponse> loginCall;

    public void request(final @NonNull WikiSite wiki, final @NonNull String userName, final @NonNull String password, final @NonNull LoginCallback cb) {
        this.cancel();
        this.tokenCall = ServiceFactory.get(wiki).getLoginToken();
        this.tokenCall.enqueue((Callback)new Callback<MwQueryResponse>(){

            public void onResponse(@NonNull Call<MwQueryResponse> call, @NonNull Response<MwQueryResponse> response) {
                LoginClient.this.login(wiki, userName, password, null, null, ((MwQueryResponse)response.body()).query().loginToken(), cb);
            }

            public void onFailure(@NonNull Call<MwQueryResponse> call, @NonNull Throwable caught) {
                if (call.isCanceled()) {
                    return;
                }
                cb.error(caught);
            }
        });
    }

    void login(final @NonNull WikiSite wiki, @NonNull String userName, final @NonNull String password, @Nullable String retypedPassword, @Nullable String twoFactorCode, final @Nullable String loginToken, final @NonNull LoginCallback cb) {
        this.loginCall = TextUtils.isEmpty((CharSequence)twoFactorCode) && TextUtils.isEmpty((CharSequence)retypedPassword) ? ServiceFactory.get(wiki).postLogIn(userName, password, loginToken, "https://wikipedia.org/") : ServiceFactory.get(wiki).postLogIn(userName, password, retypedPassword, twoFactorCode, loginToken, true);
        this.loginCall.enqueue((Callback)new Callback<LoginResponse>(){

            public void onResponse(@NonNull Call<LoginResponse> call, @NonNull Response<LoginResponse> response) {
                LoginResponse loginResponse = (LoginResponse)response.body();
                LoginResult loginResult = loginResponse.toLoginResult(wiki, password);
                if (loginResult != null) {
                    if (loginResult.pass() && !TextUtils.isEmpty((CharSequence)loginResult.getUserName())) {
                        String actualUserName = loginResult.getUserName();
                        LoginClient.this.getExtendedInfo(wiki, actualUserName, loginResult, cb);
                    } else if ("UI".equals(loginResult.getStatus())) {
                        if (loginResult instanceof LoginOAuthResult) {
                            cb.twoFactorPrompt(new LoginFailedException(loginResult.getMessage()), loginToken);
                        } else if (loginResult instanceof LoginResetPasswordResult) {
                            cb.passwordResetPrompt(loginToken);
                        } else {
                            cb.error(new LoginFailedException(loginResult.getMessage()));
                        }
                    } else {
                        cb.error(new LoginFailedException(loginResult.getMessage()));
                    }
                } else {
                    cb.error(new IOException("Login failed. Unexpected response."));
                }
            }

            public void onFailure(@NonNull Call<LoginResponse> call, @NonNull Throwable t) {
                if (call.isCanceled()) {
                    return;
                }
                cb.error(t);
            }
        });
    }

    public void loginBlocking(@NonNull WikiSite wiki, @NonNull String userName, @NonNull String password, @Nullable String twoFactorCode) throws Throwable {
        Response tokenResponse = ServiceFactory.get(wiki).getLoginToken().execute();
        if (tokenResponse.body() == null || TextUtils.isEmpty((CharSequence)((MwQueryResponse)tokenResponse.body()).query().loginToken())) {
            throw new IOException("Unexpected response when getting login token.");
        }
        String loginToken = ((MwQueryResponse)tokenResponse.body()).query().loginToken();
        Call<LoginResponse> tempLoginCall = ((String)StringUtils.defaultIfEmpty((CharSequence)twoFactorCode, (CharSequence)"")).isEmpty() ? ServiceFactory.get(wiki).postLogIn(userName, password, loginToken, "https://wikipedia.org/") : ServiceFactory.get(wiki).postLogIn(userName, password, null, twoFactorCode, loginToken, true);
        Response response = tempLoginCall.execute();
        LoginResponse loginResponse = (LoginResponse)response.body();
        if (loginResponse == null) {
            throw new IOException("Unexpected response when logging in.");
        }
        LoginResult loginResult = loginResponse.toLoginResult(wiki, password);
        if (loginResult == null) {
            throw new IOException("Unexpected response when logging in.");
        }
        if ("UI".equals(loginResult.getStatus())) {
            if (loginResult instanceof LoginOAuthResult) {
                throw new LoginFailedException(loginResult.getMessage());
            }
            throw new LoginFailedException(loginResult.getMessage());
        }
        if (!loginResult.pass() || TextUtils.isEmpty((CharSequence)loginResult.getUserName())) {
            throw new LoginFailedException(loginResult.getMessage());
        }
    }

    @SuppressLint(value={"CheckResult"})
    private void getExtendedInfo(@NonNull WikiSite wiki, @NonNull String userName, @NonNull LoginResult loginResult, @NonNull LoginCallback cb) {
        ServiceFactory.get(wiki).getUserInfo(userName).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(response -> {
            ListUserResponse user = response.query().getUserResponse(userName);
            int id = response.query().userInfo().id();
            loginResult.setUserId(id);
            loginResult.setGroups(user.getGroups());
            cb.success(loginResult);
            L.v("Found user ID " + id + " for " + wiki.subdomain());
        }, caught -> {
            L.e("Login succeeded but getting group information failed. " + caught);
            cb.error((Throwable)caught);
        });
    }

    public void cancel() {
        this.cancelTokenRequest();
        this.cancelLogin();
    }

    private void cancelTokenRequest() {
        if (this.tokenCall == null) {
            return;
        }
        this.tokenCall.cancel();
        this.tokenCall = null;
    }

    private void cancelLogin() {
        if (this.loginCall == null) {
            return;
        }
        this.loginCall.cancel();
        this.loginCall = null;
    }

    public static class LoginFailedException
    extends Throwable {
        public LoginFailedException(String message) {
            super(message);
        }
    }

    public static final class LoginResponse {
        @SerializedName(value="error")
        @Nullable
        private MwServiceError error;
        @SerializedName(value="clientlogin")
        @Nullable
        private ClientLogin clientLogin;

        @Nullable
        public MwServiceError getError() {
            return this.error;
        }

        @Nullable
        LoginResult toLoginResult(@NonNull WikiSite site, @NonNull String password) {
            return this.clientLogin != null ? this.clientLogin.toLoginResult(site, password) : null;
        }

        private static class RequestField {
            @Nullable
            private String type;
            @Nullable
            private String label;
            @Nullable
            private String help;

            private RequestField() {
            }
        }

        private static class Request {
            @Nullable
            private String id;
            @Nullable
            private String required;
            @Nullable
            private String provider;
            @Nullable
            private String account;
            @Nullable
            private Map<String, RequestField> fields;

            private Request() {
            }

            @Nullable
            String id() {
                return this.id;
            }
        }

        private static class ClientLogin {
            @NonNull
            private String status;
            @Nullable
            private List<Request> requests;
            @Nullable
            private String message;
            @SerializedName(value="username")
            @Nullable
            private String userName;

            private ClientLogin() {
            }

            LoginResult toLoginResult(@NonNull WikiSite site, @NonNull String password) {
                String userMessage = this.message;
                if ("UI".equals(this.status)) {
                    if (this.requests != null) {
                        for (Request req : this.requests) {
                            if ("TOTPAuthenticationRequest".equals(req.id())) {
                                return new LoginOAuthResult(site, this.status, this.userName, password, this.message);
                            }
                            if (!"MediaWiki\\Auth\\PasswordAuthenticationRequest".equals(req.id())) continue;
                            return new LoginResetPasswordResult(site, this.status, this.userName, password, this.message);
                        }
                    }
                } else if (!"PASS".equals(this.status) && !"FAIL".equals(this.status)) {
                    userMessage = "An unknown error occurred.";
                }
                return new LoginResult(site, this.status, this.userName, password, userMessage);
            }
        }
    }

    public static interface LoginCallback {
        public void success(@NonNull LoginResult var1);

        public void twoFactorPrompt(@NonNull Throwable var1, @Nullable String var2);

        public void passwordResetPrompt(@Nullable String var1);

        public void error(@NonNull Throwable var1);
    }
}

