/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.readinglist.sync;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.okhttp.HttpStatusException;
import org.wikipedia.readinglist.sync.SyncedReadingLists;
import retrofit2.Response;

public class ReadingListClient {
    @NonNull
    private final WikiSite wiki;
    @Nullable
    private String lastDateHeader;
    private static final int MAX_CONTINUE_CYCLES = 256;

    public ReadingListClient(@NonNull WikiSite wiki) {
        this.wiki = wiki;
    }

    @Nullable
    public String getLastDateHeader() {
        return this.lastDateHeader;
    }

    public boolean setup(@NonNull String csrfToken) throws Throwable {
        try {
            ServiceFactory.getRest(this.wiki).setupReadingLists(csrfToken).execute();
            return true;
        }
        catch (Throwable t) {
            if (this.isErrorType(t, "already-set-up")) {
                return false;
            }
            throw t;
        }
    }

    public void tearDown(@NonNull String csrfToken) throws Throwable {
        try {
            ServiceFactory.getRest(this.wiki).tearDownReadingLists(csrfToken).execute();
        }
        catch (Throwable t) {
            if (this.isErrorType(t, "not-set-up")) {
                return;
            }
            throw t;
        }
    }

    @NonNull
    public List<SyncedReadingLists.RemoteReadingList> getAllLists() throws Throwable {
        ArrayList<SyncedReadingLists.RemoteReadingList> totalLists = new ArrayList<SyncedReadingLists.RemoteReadingList>();
        int totalCycles = 0;
        String continueStr = null;
        do {
            Response response;
            SyncedReadingLists lists;
            if ((lists = (SyncedReadingLists)(response = ServiceFactory.getRest(this.wiki).getReadingLists(continueStr).execute()).body()) == null || lists.getLists() == null) {
                throw new IOException("Incorrect response format.");
            }
            totalLists.addAll(lists.getLists());
            continueStr = TextUtils.isEmpty((CharSequence)lists.getContinueStr()) ? null : lists.getContinueStr();
            this.saveLastDateHeader(response);
        } while (!TextUtils.isEmpty((CharSequence)continueStr) && totalCycles++ < 256);
        return totalLists;
    }

    @NonNull
    public SyncedReadingLists getChangesSince(@NonNull String date) throws Throwable {
        ArrayList<SyncedReadingLists.RemoteReadingList> totalLists = new ArrayList<SyncedReadingLists.RemoteReadingList>();
        ArrayList<SyncedReadingLists.RemoteReadingListEntry> totalEntries = new ArrayList<SyncedReadingLists.RemoteReadingListEntry>();
        int totalCycles = 0;
        String continueStr = null;
        do {
            Response response;
            SyncedReadingLists body;
            if ((body = (SyncedReadingLists)(response = ServiceFactory.getRest(this.wiki).getReadingListChangesSince(date, continueStr).execute()).body()) == null) {
                throw new IOException("Incorrect response format.");
            }
            if (body.getLists() != null) {
                totalLists.addAll(body.getLists());
            }
            if (body.getEntries() != null) {
                totalEntries.addAll(body.getEntries());
            }
            continueStr = TextUtils.isEmpty((CharSequence)body.getContinueStr()) ? null : body.getContinueStr();
            this.saveLastDateHeader(response);
        } while (!TextUtils.isEmpty((CharSequence)continueStr) && totalCycles++ < 256);
        return new SyncedReadingLists(totalLists, totalEntries);
    }

    @NonNull
    public List<SyncedReadingLists.RemoteReadingList> getListsContaining(@NonNull SyncedReadingLists.RemoteReadingListEntry entry) throws Throwable {
        ArrayList<SyncedReadingLists.RemoteReadingList> totalLists = new ArrayList<SyncedReadingLists.RemoteReadingList>();
        int totalCycles = 0;
        String continueStr = null;
        do {
            Response response;
            SyncedReadingLists lists;
            if ((lists = (SyncedReadingLists)(response = ServiceFactory.getRest(this.wiki).getReadingListsContaining(entry.project(), entry.title(), continueStr).execute()).body()) == null || lists.getLists() == null) {
                throw new IOException("Incorrect response format.");
            }
            totalLists.addAll(lists.getLists());
            continueStr = TextUtils.isEmpty((CharSequence)lists.getContinueStr()) ? null : lists.getContinueStr();
            this.saveLastDateHeader(response);
        } while (!TextUtils.isEmpty((CharSequence)continueStr) && totalCycles++ < 256);
        return totalLists;
    }

    @NonNull
    public List<SyncedReadingLists.RemoteReadingListEntry> getListEntries(long listId) throws Throwable {
        ArrayList<SyncedReadingLists.RemoteReadingListEntry> totalEntries = new ArrayList<SyncedReadingLists.RemoteReadingListEntry>();
        int totalCycles = 0;
        String continueStr = null;
        do {
            Response response;
            SyncedReadingLists body;
            if ((body = (SyncedReadingLists)(response = ServiceFactory.getRest(this.wiki).getReadingListEntries(listId, continueStr).execute()).body()) == null || body.getEntries() == null) {
                throw new IOException("Incorrect response format.");
            }
            totalEntries.addAll(body.getEntries());
            continueStr = TextUtils.isEmpty((CharSequence)body.getContinueStr()) ? null : body.getContinueStr();
            this.saveLastDateHeader(response);
        } while (!TextUtils.isEmpty((CharSequence)continueStr) && totalCycles++ < 256);
        return totalEntries;
    }

    public long createList(@NonNull String csrfToken, @NonNull SyncedReadingLists.RemoteReadingList list) throws Throwable {
        Response response = ServiceFactory.getRest(this.wiki).createReadingList(csrfToken, list).execute();
        SyncedReadingLists.RemoteIdResponse idResponse = (SyncedReadingLists.RemoteIdResponse)response.body();
        if (idResponse == null) {
            throw new IOException("Incorrect response format.");
        }
        this.saveLastDateHeader(response);
        return idResponse.id();
    }

    public void updateList(@NonNull String csrfToken, long listId, @NonNull SyncedReadingLists.RemoteReadingList list) throws Throwable {
        Response response = ServiceFactory.getRest(this.wiki).updateReadingList(listId, csrfToken, list).execute();
        this.saveLastDateHeader(response);
    }

    public void deleteList(@NonNull String csrfToken, long listId) throws Throwable {
        Response response = ServiceFactory.getRest(this.wiki).deleteReadingList(listId, csrfToken).execute();
        this.saveLastDateHeader(response);
    }

    public long addPageToList(@NonNull String csrfToken, long listId, @NonNull SyncedReadingLists.RemoteReadingListEntry entry) throws Throwable {
        Response response = ServiceFactory.getRest(this.wiki).addEntryToReadingList(listId, csrfToken, entry).execute();
        SyncedReadingLists.RemoteIdResponse idResponse = (SyncedReadingLists.RemoteIdResponse)response.body();
        if (idResponse == null) {
            throw new IOException("Incorrect response format.");
        }
        this.saveLastDateHeader(response);
        return idResponse.id();
    }

    /*
     * Loose catch block
     */
    public List<Long> addPagesToList(@NonNull String csrfToken, long listId, @NonNull List<SyncedReadingLists.RemoteReadingListEntry> entries) throws Throwable {
        ArrayList<Long> ids;
        block6: {
            int maxBatchSize = 50;
            int batchIndex = 0;
            ids = new ArrayList<Long>();
            ArrayList<SyncedReadingLists.RemoteReadingListEntry> currentBatch = new ArrayList<SyncedReadingLists.RemoteReadingListEntry>();
            block2: while (true) {
                currentBatch.clear();
                while (batchIndex < entries.size() && currentBatch.size() < 50) {
                    currentBatch.add(entries.get(batchIndex++));
                }
                if (currentBatch.isEmpty()) break block6;
                Response response = ServiceFactory.getRest(this.wiki).addEntriesToReadingList(listId, csrfToken, new SyncedReadingLists.RemoteReadingListEntryBatch(currentBatch)).execute();
                SyncedReadingLists.RemoteIdResponseBatch idResponse = (SyncedReadingLists.RemoteIdResponseBatch)response.body();
                if (idResponse == null) {
                    throw new IOException("Incorrect response format.");
                }
                this.saveLastDateHeader(response);
                SyncedReadingLists.RemoteIdResponse[] remoteIdResponseArray = idResponse.batch();
                int n = remoteIdResponseArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    SyncedReadingLists.RemoteIdResponse id = remoteIdResponseArray[n2];
                    ids.add(id.id());
                    ++n2;
                }
                break;
            }
            catch (Throwable t) {
                if (this.isErrorType(t, "entry-limit")) break block6;
                throw t;
            }
        }
        return ids;
    }

    public void deletePageFromList(@NonNull String csrfToken, long listId, long entryId) throws Throwable {
        Response response = ServiceFactory.getRest(this.wiki).deleteEntryFromReadingList(listId, entryId, csrfToken).execute();
        this.saveLastDateHeader(response);
    }

    public boolean isErrorType(Throwable t, @NonNull String errorType) {
        return t instanceof HttpStatusException && ((HttpStatusException)t).serviceError() != null && ((HttpStatusException)t).serviceError().getTitle().contains(errorType);
    }

    public boolean isServiceError(Throwable t) {
        int code = 400;
        return t instanceof HttpStatusException && ((HttpStatusException)t).code() == 400;
    }

    public boolean isUnavailableError(Throwable t) {
        int code = 405;
        return t instanceof HttpStatusException && ((HttpStatusException)t).code() == 405;
    }

    private void saveLastDateHeader(@NonNull Response response) {
        this.lastDateHeader = response.headers().get("date");
    }
}

