/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.feed.announcement;

import android.location.Location;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import org.wikipedia.dataclient.SharedPreferenceCookieManager;
import org.wikipedia.feed.announcement.GeoIPCookie;

public final class GeoIPCookieUnmarshaller {
    private static final String COOKIE_NAME = "GeoIP";

    @NonNull
    public static GeoIPCookie unmarshal() {
        return GeoIPCookieUnmarshaller.unmarshal(SharedPreferenceCookieManager.getInstance().getCookieByName(COOKIE_NAME));
    }

    @VisibleForTesting
    @NonNull
    static GeoIPCookie unmarshal(@Nullable String cookie) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)cookie)) {
            throw new IllegalArgumentException("Cookie is empty.");
        }
        String[] components = cookie.split(":");
        if (components.length < Component.values().length) {
            throw new IllegalArgumentException("Cookie is malformed.");
        }
        if (!components[Component.VERSION.ordinal()].equals("v4")) {
            throw new IllegalArgumentException("Incorrect cookie version.");
        }
        Location location = null;
        if (!TextUtils.isEmpty((CharSequence)components[Component.LATITUDE.ordinal()]) && !TextUtils.isEmpty((CharSequence)components[Component.LONGITUDE.ordinal()])) {
            location = new Location("");
            try {
                location.setLatitude(Double.parseDouble(components[Component.LATITUDE.ordinal()]));
                location.setLongitude(Double.parseDouble(components[Component.LONGITUDE.ordinal()]));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Location is malformed.");
            }
        }
        return new GeoIPCookie(components[Component.COUNTRY.ordinal()], components[Component.REGION.ordinal()], components[Component.CITY.ordinal()], location);
    }

    private GeoIPCookieUnmarshaller() {
    }

    private static enum Component {
        COUNTRY,
        REGION,
        CITY,
        LATITUDE,
        LONGITUDE,
        VERSION;

    }
}

