/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.feed.onthisday;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.dataclient.restbase.page.RbPageSummary;
import org.wikipedia.json.annotations.Required;
import org.wikipedia.util.StringUtil;

public class OnThisDay {
    @Nullable
    private List<Event> selected;
    @Nullable
    private List<Event> events;
    @Nullable
    private List<Event> births;
    @Nullable
    private List<Event> deaths;
    @Nullable
    private List<Event> holidays;

    @NonNull
    public List<Event> selectedEvents() {
        return this.selected != null ? this.selected : Collections.emptyList();
    }

    @NonNull
    public List<Event> events() {
        ArrayList<Event> allEvents = new ArrayList<Event>();
        if (this.events != null) {
            allEvents.addAll(this.events);
        }
        if (this.births != null) {
            allEvents.addAll(this.births);
        }
        if (this.deaths != null) {
            allEvents.addAll(this.deaths);
        }
        if (this.holidays != null) {
            allEvents.addAll(this.holidays);
        }
        Collections.sort(allEvents, (e1, e2) -> Integer.compare(e2.year(), e1.year()));
        return allEvents;
    }

    public void setSelected(@Nullable List<Event> selected) {
        this.selected = selected;
    }

    public static class Event {
        @Required
        @NonNull
        private String text;
        private int year;
        @Required
        @NonNull
        private List<RbPageSummary> pages;

        @NonNull
        public CharSequence text() {
            ArrayList<String> pageTitles = new ArrayList<String>();
            for (RbPageSummary page : this.pages) {
                pageTitles.add(StringUtil.fromHtml(StringUtils.defaultString((String)page.getNormalizedTitle())).toString());
            }
            return StringUtil.boldenSubstrings(this.text, pageTitles);
        }

        public int year() {
            return this.year;
        }

        @Nullable
        public List<RbPageSummary> pages() {
            Iterator<RbPageSummary> iterator = this.pages.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
            }
            return this.pages;
        }
    }
}

