/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.restbase.page;

import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.wikipedia.dataclient.page.PageLead;
import org.wikipedia.dataclient.page.PageLeadProperties;
import org.wikipedia.dataclient.page.Protection;
import org.wikipedia.page.GeoTypeAdapter;
import org.wikipedia.page.Namespace;
import org.wikipedia.page.Page;
import org.wikipedia.page.PageProperties;
import org.wikipedia.page.PageTitle;
import org.wikipedia.page.Section;
import org.wikipedia.util.UriUtil;

public class RbPageLead
implements PageLead,
PageLeadProperties {
    private int ns;
    private int id;
    private long revision;
    @Nullable
    private String lastmodified;
    @Nullable
    private String displaytitle;
    @Nullable
    private String redirected;
    @Nullable
    private String normalizedtitle;
    @SerializedName(value="wikibase_item")
    @Nullable
    private String wikiBaseItem;
    @SerializedName(value="pronunciation")
    @Nullable
    private TitlePronunciation titlePronunciation;
    @JsonAdapter(value=GeoTypeAdapter.class)
    @Nullable
    private Location geo;
    private int languagecount;
    private boolean editable;
    private boolean mainpage;
    private boolean disambiguation;
    @Nullable
    private String description;
    @SerializedName(value="description_source")
    @Nullable
    private String descriptionSource;
    @Nullable
    private Image image;
    @Nullable
    private Protection protection;
    @Nullable
    private List<Section> sections;

    @Override
    public Page toPage(PageTitle title) {
        return new Page(this.adjustPageTitle(title), this.getSections(), this.toPageProperties(), true);
    }

    PageTitle adjustPageTitle(PageTitle title) {
        if (this.redirected != null) {
            title = new PageTitle(this.redirected, title.getWikiSite(), title.getThumbUrl());
        } else if (this.normalizedtitle != null) {
            title = new PageTitle(this.normalizedtitle, title.getWikiSite(), title.getThumbUrl());
        }
        title.setDescription(this.description);
        return title;
    }

    @Override
    public String getLeadSectionContent() {
        if (this.sections != null) {
            return this.sections.get(0).getContent();
        }
        return "";
    }

    private PageProperties toPageProperties() {
        return new PageProperties(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NonNull
    public Namespace getNamespace() {
        return Namespace.of(this.ns);
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    @Nullable
    public String getLastModified() {
        return this.lastmodified;
    }

    @Override
    @Nullable
    public String getTitlePronunciationUrl() {
        return this.titlePronunciation == null ? null : UriUtil.resolveProtocolRelativeUrl(this.titlePronunciation.getUrl());
    }

    @Override
    @Nullable
    public Location getGeo() {
        return this.geo;
    }

    @Override
    public int getLanguageCount() {
        return this.languagecount;
    }

    @Override
    @Nullable
    public String getDisplayTitle() {
        return this.displaytitle;
    }

    @Override
    @Nullable
    public String getRedirected() {
        return this.redirected;
    }

    @Override
    @Nullable
    public String getNormalizedTitle() {
        return this.normalizedtitle;
    }

    @Override
    @Nullable
    public String getWikiBaseItem() {
        return this.wikiBaseItem;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getDescriptionSource() {
        return this.descriptionSource;
    }

    @Override
    @Nullable
    public String getLeadImageUrl(int leadImageWidth) {
        return this.image != null ? this.image.getUrl(leadImageWidth) : null;
    }

    @Override
    @Nullable
    public String getThumbUrl() {
        return this.image != null ? this.image.getUrl(320) : null;
    }

    @Override
    @Nullable
    public String getLeadImageFileName() {
        return this.image != null ? this.image.getFileName() : null;
    }

    @Override
    @Nullable
    public String getFirstAllowedEditorRole() {
        return this.protection != null ? this.protection.getFirstAllowedEditorRole() : null;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public Set<String> getEditRoles() {
        return this.protection != null ? this.protection.getEditRoles() : Collections.emptySet();
    }

    @Override
    public boolean isMainPage() {
        return this.mainpage;
    }

    @Override
    public boolean isDisambiguation() {
        return this.disambiguation;
    }

    @Override
    @NonNull
    public List<Section> getSections() {
        return this.sections == null ? Collections.emptyList() : this.sections;
    }

    public static class ThumbUrls {
        private static final int SMALL = 320;
        private static final int MEDIUM = 640;
        private static final int LARGE = 800;
        private static final int XL = 1024;
        @SerializedName(value="320")
        private String small;
        @SerializedName(value="640")
        private String medium;
        @SerializedName(value="800")
        private String large;
        @SerializedName(value="1024")
        private String xl;

        @Nullable
        public String get(int width) {
            switch (width) {
                case 320: {
                    return this.small;
                }
                case 640: {
                    return this.medium;
                }
                case 800: {
                    return this.large;
                }
                case 1024: {
                    return this.xl;
                }
            }
            return null;
        }
    }

    public static class Image {
        @SerializedName(value="file")
        private String fileName;
        private ThumbUrls urls;

        public String getFileName() {
            return this.fileName;
        }

        @Nullable
        public String getUrl(int width) {
            return this.urls != null ? this.urls.get(width) : null;
        }
    }

    public static class TitlePronunciation {
        @NonNull
        private String url;

        @NonNull
        public String getUrl() {
            return this.url;
        }
    }
}

