/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.readinglist.sync;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import java.text.Normalizer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.dataclient.restbase.page.RbPageSummary;
import org.wikipedia.json.annotations.Required;

public class SyncedReadingLists {
    @Nullable
    private List<RemoteReadingList> lists;
    @Nullable
    private List<RemoteReadingListEntry> entries;
    @Nullable
    private String next;

    public SyncedReadingLists() {
    }

    public SyncedReadingLists(@NonNull List<RemoteReadingList> lists, @NonNull List<RemoteReadingListEntry> entries) {
        this.lists = lists;
        this.entries = entries;
    }

    @Nullable
    public List<RemoteReadingList> getLists() {
        return this.lists;
    }

    @Nullable
    public List<RemoteReadingListEntry> getEntries() {
        return this.entries;
    }

    @Nullable
    public String getContinueStr() {
        return this.next;
    }

    public class RemoteIdResponseBatch {
        @Required
        private RemoteIdResponse[] batch;

        public RemoteIdResponse[] batch() {
            return this.batch;
        }
    }

    public class RemoteIdResponse {
        @Required
        private long id;

        public long id() {
            return this.id;
        }
    }

    public static class RemoteReadingListEntryBatch {
        private RemoteReadingListEntry[] batch;

        public RemoteReadingListEntryBatch() {
        }

        public RemoteReadingListEntryBatch(@NonNull List<RemoteReadingListEntry> entries) {
            this.batch = entries.toArray(new RemoteReadingListEntry[0]);
        }
    }

    public static class RemoteReadingListEntry {
        private long id;
        private long listId;
        @Required
        @NonNull
        private String project;
        @Required
        @NonNull
        private String title;
        @Required
        @NonNull
        private String created;
        @Required
        @NonNull
        private String updated;
        @Nullable
        private RbPageSummary summary;
        private boolean deleted;

        public RemoteReadingListEntry() {
        }

        public RemoteReadingListEntry(@NonNull String project, @NonNull String title) {
            this.project = Normalizer.normalize(project, Normalizer.Form.NFC);
            this.title = Normalizer.normalize(title, Normalizer.Form.NFC);
        }

        public long id() {
            return this.id;
        }

        public long listId() {
            return this.listId;
        }

        @NonNull
        public String project() {
            return Normalizer.normalize(this.project, Normalizer.Form.NFC);
        }

        @NonNull
        public String title() {
            return Normalizer.normalize(this.title, Normalizer.Form.NFC);
        }

        @NonNull
        public String updatedDate() {
            return this.updated;
        }

        @Nullable
        public RbPageSummary summary() {
            return this.summary;
        }

        public boolean isDeleted() {
            return this.deleted;
        }
    }

    public static class RemoteReadingList {
        @Required
        private long id;
        @SerializedName(value="default")
        private boolean isDefault;
        @Required
        @NonNull
        private String name;
        @Nullable
        private String description;
        @Required
        @NonNull
        private String created;
        @Required
        @NonNull
        private String updated;
        private boolean deleted;

        public RemoteReadingList() {
        }

        public RemoteReadingList(@NonNull String name, @Nullable String description) {
            this.name = Normalizer.normalize(name, Normalizer.Form.NFC);
            this.description = Normalizer.normalize(StringUtils.defaultString((String)description), Normalizer.Form.NFC);
        }

        public long id() {
            return this.id;
        }

        @NonNull
        public String name() {
            return Normalizer.normalize(this.name, Normalizer.Form.NFC);
        }

        @NonNull
        public String description() {
            return Normalizer.normalize(StringUtils.defaultString((String)this.description), Normalizer.Form.NFC);
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        @NonNull
        public String updatedDate() {
            return this.updated;
        }
    }
}

