/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.edit.preview;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import org.wikipedia.dataclient.Service;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.edit.preview.EditPreview;
import org.wikipedia.page.PageTitle;
import retrofit2.Call;
import retrofit2.Response;

class EditPreviewClient {
    EditPreviewClient() {
    }

    Call<EditPreview> request(@NonNull WikiSite wiki, @NonNull PageTitle title, @NonNull String wikitext, @NonNull Callback cb) {
        return this.request(ServiceFactory.get(wiki), title, wikitext, cb);
    }

    @VisibleForTesting
    Call<EditPreview> request(@NonNull Service service, @NonNull PageTitle title, @NonNull String wikitext, final @NonNull Callback cb) {
        Call<EditPreview> call = service.postEditPreview(title.getPrefixedText(), wikitext);
        call.enqueue((retrofit2.Callback)new retrofit2.Callback<EditPreview>(){

            public void onResponse(Call<EditPreview> call, Response<EditPreview> response) {
                if (((EditPreview)response.body()).hasPreviewResult()) {
                    cb.success(call, ((EditPreview)response.body()).result());
                } else {
                    cb.failure(call, new IOException("An unknown error occurred."));
                }
            }

            public void onFailure(Call<EditPreview> call, Throwable t) {
                cb.failure(call, t);
            }
        });
        return call;
    }

    public static interface Callback {
        public void success(@NonNull Call<EditPreview> var1, @NonNull String var2);

        public void failure(@NonNull Call<EditPreview> var1, @NonNull Throwable var2);
    }
}

