/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.gallery;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.gallery.ArtistInfo;
import org.wikipedia.gallery.ImageInfo;
import org.wikipedia.gallery.ImageLicense;
import org.wikipedia.gallery.TextInfo;
import org.wikipedia.gallery.VideoInfo;
import org.wikipedia.util.ImageUrlUtil;
import org.wikipedia.util.StringUtil;

public class GalleryItem
implements Serializable {
    public static final int PREFERRED_GALLERY_IMAGE_SIZE = 1280;
    @SerializedName(value="section_id")
    private int sectionId;
    @NonNull
    private String type;
    @SerializedName(value="audio_type")
    @Nullable
    private String audioType;
    @Nullable
    private TextInfo caption;
    private boolean showInGallery;
    @NonNull
    private Titles titles;
    @Nullable
    private ImageInfo thumbnail;
    @Nullable
    private ImageInfo original;
    @Nullable
    private List<VideoInfo> sources;
    @SerializedName(value="file_page")
    @Nullable
    private String filePage;
    @Nullable
    private ArtistInfo artist;
    private double duration;
    @NonNull
    private ImageLicense license;
    @Nullable
    private TextInfo description;

    public GalleryItem() {
    }

    public GalleryItem(@NonNull String title) {
        this.type = "*/*";
        this.titles = new Titles(title, StringUtil.addUnderscores(title), title);
        this.original = new ImageInfo();
        this.thumbnail = new ImageInfo();
        this.description = new TextInfo();
        this.license = new ImageLicense();
    }

    @NonNull
    public String getType() {
        return StringUtils.defaultString((String)this.type);
    }

    @NonNull
    public String getAudioType() {
        return StringUtils.defaultString((String)this.audioType);
    }

    @Nullable
    public TextInfo getCaption() {
        return this.caption;
    }

    public boolean isShowInGallery() {
        return this.showInGallery;
    }

    @NonNull
    public Titles getTitles() {
        return this.titles;
    }

    protected void setTitle(@NonNull String title) {
        this.titles = new Titles(title, StringUtil.addUnderscores(title), title);
    }

    @NonNull
    public ImageInfo getThumbnail() {
        if (this.thumbnail == null) {
            this.thumbnail = new ImageInfo();
        }
        return this.thumbnail;
    }

    @NonNull
    public String getThumbnailUrl() {
        return this.getThumbnail().getSource();
    }

    @NonNull
    public String getPreferredSizedImageUrl() {
        return ImageUrlUtil.getUrlForPreferredSize(this.getThumbnailUrl(), 1280);
    }

    @NonNull
    public ImageInfo getOriginal() {
        if (this.original == null) {
            this.original = new ImageInfo();
        }
        return this.original;
    }

    @Nullable
    public List<VideoInfo> getSources() {
        return this.sources;
    }

    @Nullable
    public VideoInfo getOriginalVideoSource() {
        return this.sources == null || this.sources.size() == 0 ? null : this.sources.get(this.sources.size() - 1);
    }

    public double getDuration() {
        return this.duration;
    }

    @NonNull
    public String getFilePage() {
        return this.filePage == null ? "https://commons.wikimedia.org/" : StringUtils.defaultString((String)this.filePage);
    }

    public void setFilePage(@NonNull String filePage) {
        this.filePage = filePage;
    }

    @Nullable
    public ArtistInfo getArtist() {
        return this.artist;
    }

    public void setArtist(@Nullable ArtistInfo artist) {
        this.artist = artist;
    }

    @NonNull
    public ImageLicense getLicense() {
        return this.license;
    }

    public void setLicense(@NonNull ImageLicense license) {
        this.license = license;
    }

    @NonNull
    public TextInfo getDescription() {
        if (this.description == null) {
            this.description = new TextInfo();
        }
        return this.description;
    }

    public static class Titles
    implements Serializable {
        @Nullable
        private String canonical;
        @Nullable
        private String normalized;
        @Nullable
        private String display;

        Titles(@NonNull String display, @NonNull String canonical, @NonNull String normalized) {
            this.display = display;
            this.canonical = canonical;
            this.normalized = normalized;
        }

        @NonNull
        public String getCanonical() {
            return StringUtils.defaultString((String)this.canonical);
        }

        @NonNull
        public String getNormalized() {
            return StringUtils.defaultString((String)this.normalized);
        }

        @NonNull
        public String getDisplay() {
            return StringUtils.defaultString((String)this.display);
        }
    }
}

