/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.feed.announcement;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.json.annotations.Required;
import org.wikipedia.model.BaseModel;
import org.wikipedia.util.DateUtil;

public class Announcement
extends BaseModel {
    public static final String SURVEY = "survey";
    public static final String FUNDRAISING = "fundraising";
    @Required
    @NonNull
    private String id;
    @Required
    @NonNull
    private String type;
    @SerializedName(value="start_time")
    @Required
    @NonNull
    private String startTime;
    @SerializedName(value="end_time")
    @Required
    @NonNull
    private String endTime;
    @NonNull
    private List<String> platforms = Collections.emptyList();
    @NonNull
    private List<String> countries = Collections.emptyList();
    @SerializedName(value="caption_HTML")
    @Nullable
    private String footerCaption;
    @SerializedName(value="image_url")
    @Nullable
    private String imageUrl;
    @SerializedName(value="image_height")
    @Nullable
    private String imageHeight;
    @SerializedName(value="logged_in")
    @Nullable
    private Boolean loggedIn;
    @SerializedName(value="reading_list_sync_enabled")
    @Nullable
    private Boolean readingListSyncEnabled;
    @Nullable
    private Boolean beta;
    @SerializedName(value="min_version")
    @Nullable
    private String minVersion;
    @SerializedName(value="max_version")
    @Nullable
    private String maxVersion;
    @Required
    @NonNull
    private String text;
    @Nullable
    private Action action;
    @SerializedName(value="negative_text")
    @Nullable
    private String negativeText;

    public Announcement() {
    }

    public Announcement(@NonNull String id, @NonNull String text, @NonNull String imageUrl, @NonNull Action action, @NonNull String negativeText) {
        this.id = id;
        this.text = text;
        this.imageUrl = imageUrl;
        this.action = action;
        this.negativeText = negativeText;
    }

    @NonNull
    String id() {
        return this.id;
    }

    @NonNull
    String type() {
        return this.type;
    }

    @Nullable
    Date startTime() {
        try {
            return DateUtil.getIso8601DateFormat().parse(this.startTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nullable
    Date endTime() {
        try {
            return DateUtil.getIso8601DateFormat().parse(this.endTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @NonNull
    List<String> platforms() {
        return this.platforms;
    }

    @NonNull
    List<String> countries() {
        return this.countries;
    }

    @NonNull
    String text() {
        return this.text;
    }

    boolean hasAction() {
        return this.action != null;
    }

    @NonNull
    String actionTitle() {
        return this.action != null ? this.action.title() : "";
    }

    @NonNull
    String actionUrl() {
        return this.action != null ? this.action.url() : "";
    }

    boolean hasFooterCaption() {
        return !TextUtils.isEmpty((CharSequence)this.footerCaption);
    }

    @NonNull
    String footerCaption() {
        return StringUtils.defaultString((String)this.footerCaption);
    }

    boolean hasImageUrl() {
        return !TextUtils.isEmpty((CharSequence)this.imageUrl);
    }

    @NonNull
    String imageUrl() {
        return StringUtils.defaultString((String)this.imageUrl);
    }

    @NonNull
    String imageHeight() {
        return StringUtils.defaultString((String)this.imageHeight);
    }

    @Nullable
    String negativeText() {
        return this.negativeText;
    }

    @Nullable
    Boolean loggedIn() {
        return this.loggedIn;
    }

    @Nullable
    Boolean readingListSyncEnabled() {
        return this.readingListSyncEnabled;
    }

    @Nullable
    Boolean beta() {
        return this.beta;
    }

    @Nullable
    String minVersion() {
        return this.minVersion;
    }

    @Nullable
    String maxVersion() {
        return this.maxVersion;
    }

    public static class Action {
        @Required
        @NonNull
        private String title;
        @Required
        @NonNull
        private String url;

        public Action(@NonNull String title, @NonNull String url) {
            this.title = title;
            this.url = url;
        }

        @NonNull
        String title() {
            return this.title;
        }

        @NonNull
        String url() {
            return this.url;
        }
    }
}

