/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.restbase.page;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.page.PageSummary;
import org.wikipedia.json.annotations.Required;
import org.wikipedia.page.Namespace;
import org.wikipedia.page.PageTitle;

public class RbPageSummary
implements PageSummary {
    @Nullable
    private String type;
    @Required
    @NonNull
    private String title;
    @Nullable
    private String normalizedtitle;
    @NonNull
    private String displaytitle;
    @Nullable
    private NamespaceContainer namespace;
    @Nullable
    private String extract;
    @SerializedName(value="extract_html")
    @Nullable
    private String extractHtml;
    @Nullable
    private String description;
    @Nullable
    private Thumbnail thumbnail;
    @SerializedName(value="originalimage")
    @Nullable
    private Thumbnail originalImage;
    @Nullable
    private String lang;
    private int pageid;
    @SerializedName(value="wikibase_item")
    @Nullable
    private String wikiBaseItem;

    @Override
    @NonNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NonNull
    public String getDisplayTitle() {
        return this.displaytitle;
    }

    @Override
    @NonNull
    public String getConvertedTitle() {
        return this.title;
    }

    @Override
    @NonNull
    public Namespace getNamespace() {
        return this.namespace == null ? Namespace.MAIN : Namespace.of(this.namespace.id());
    }

    @Override
    @NonNull
    public String getType() {
        return TextUtils.isEmpty((CharSequence)this.type) ? "standard" : this.type;
    }

    @Override
    @Nullable
    public String getExtract() {
        return this.extract;
    }

    @Override
    @Nullable
    public String getExtractHtml() {
        return this.extractHtml;
    }

    @Override
    @Nullable
    public String getThumbnailUrl() {
        return this.thumbnail == null ? null : this.thumbnail.getUrl();
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getNormalizedTitle() {
        return this.normalizedtitle == null ? this.title : this.normalizedtitle;
    }

    @Nullable
    public String getOriginalImageUrl() {
        return this.originalImage == null ? null : this.originalImage.getUrl();
    }

    @Nullable
    public String getWikiBaseItem() {
        return this.wikiBaseItem;
    }

    @NonNull
    public PageTitle getPageTitle(@NonNull WikiSite wiki) {
        return new PageTitle(this.getTitle(), wiki, this.getThumbnailUrl(), this.getDescription());
    }

    @Override
    public int getPageId() {
        return this.pageid;
    }

    public String toString() {
        return this.getTitle();
    }

    private static class NamespaceContainer {
        private int id;
        @Nullable
        private String text;

        private NamespaceContainer() {
        }

        public int id() {
            return this.id;
        }
    }

    private static class Thumbnail {
        private String source;

        private Thumbnail() {
        }

        public String getUrl() {
            return this.source;
        }
    }
}

