/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.mwapi;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.mwapi.MwQueryPage;
import org.wikipedia.page.PageTitle;

public class NearbyPage {
    @NonNull
    private PageTitle title;
    @Nullable
    private Location location;
    private int distance;

    public NearbyPage(@NonNull MwQueryPage page, @NonNull WikiSite wiki) {
        this.title = new PageTitle(page.title(), wiki);
        this.title.setThumbUrl(page.thumbUrl());
        List<MwQueryPage.Coordinates> coordinates = page.coordinates();
        if (coordinates == null || coordinates.isEmpty()) {
            return;
        }
        if (coordinates.get(0).lat() != null && coordinates.get(0).lon() != null) {
            this.location = new Location(this.title.getPrefixedText());
            this.location.setLatitude(coordinates.get(0).lat().doubleValue());
            this.location.setLongitude(coordinates.get(0).lon().doubleValue());
        }
    }

    public NearbyPage(@NonNull PageTitle title, @Nullable Location location) {
        this.title = title;
        this.location = location;
    }

    @NonNull
    public PageTitle getTitle() {
        return this.title;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "NearbyPage{title='" + this.title + '\'' + ", thumbUrl='" + this.title.getThumbUrl() + '\'' + ", location=" + this.location + '\'' + ", distance='" + this.distance + '}';
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }
}

