/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.util.log;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import org.wikipedia.AppAdapter;
import org.wikipedia.util.log.RemoteExceptionLogger;

public final class L {
    private static final LogLevel LEVEL_V = new LogLevel(){

        @Override
        public void logLevel(String tag, String msg, Throwable t) {
            Log.v((String)tag, (String)msg, (Throwable)t);
        }
    };
    private static final LogLevel LEVEL_D = new LogLevel(){

        @Override
        public void logLevel(String tag, String msg, Throwable t) {
            Log.d((String)tag, (String)msg, (Throwable)t);
        }
    };
    private static final LogLevel LEVEL_I = new LogLevel(){

        @Override
        public void logLevel(String tag, String msg, Throwable t) {
            Log.i((String)tag, (String)msg, (Throwable)t);
        }
    };
    private static final LogLevel LEVEL_W = new LogLevel(){

        @Override
        public void logLevel(String tag, String msg, Throwable t) {
            Log.w((String)tag, (String)msg, (Throwable)t);
        }
    };
    private static final LogLevel LEVEL_E = new LogLevel(){

        @Override
        public void logLevel(String tag, String msg, Throwable t) {
            Log.e((String)tag, (String)msg, (Throwable)t);
        }
    };
    @Nullable
    private static RemoteExceptionLogger REMOTE_EXCEPTION_LOGGER;

    public static void v(CharSequence msg) {
        LEVEL_V.log(msg, null);
    }

    public static void d(CharSequence msg) {
        LEVEL_D.log(msg, null);
    }

    public static void i(CharSequence msg) {
        LEVEL_I.log(msg, null);
    }

    public static void w(CharSequence msg) {
        LEVEL_W.log(msg, null);
    }

    public static void e(CharSequence msg) {
        LEVEL_E.log(msg, null);
    }

    public static void v(Throwable t) {
        LEVEL_V.log("", t);
    }

    public static void d(Throwable t) {
        LEVEL_D.log("", t);
    }

    public static void i(Throwable t) {
        LEVEL_I.log("", t);
    }

    public static void w(Throwable t) {
        LEVEL_W.log("", t);
    }

    public static void e(Throwable t) {
        LEVEL_E.log("", t);
    }

    public static void v(CharSequence msg, Throwable t) {
        LEVEL_V.log(msg, t);
    }

    public static void d(CharSequence msg, Throwable t) {
        LEVEL_D.log(msg, t);
    }

    public static void i(CharSequence msg, Throwable t) {
        LEVEL_I.log(msg, t);
    }

    public static void w(CharSequence msg, Throwable t) {
        LEVEL_W.log(msg, t);
    }

    public static void e(CharSequence msg, Throwable t) {
        LEVEL_E.log(msg, t);
    }

    public static void logRemoteErrorIfProd(@NonNull Throwable t) {
        if (!AppAdapter.get().logErrorsInsteadOfCrashing()) {
            throw new RuntimeException(t);
        }
        L.logRemoteError(t);
    }

    public static void setRemoteLogger(@Nullable RemoteExceptionLogger logger) {
        REMOTE_EXCEPTION_LOGGER = logger;
    }

    public static void logRemoteError(@NonNull Throwable t) {
        LEVEL_E.log("", t);
        if (REMOTE_EXCEPTION_LOGGER != null) {
            REMOTE_EXCEPTION_LOGGER.log(t);
        }
    }

    private L() {
    }

    private static abstract class LogLevel {
        private static final int STACK_INDEX = 4;

        private LogLevel() {
        }

        public abstract void logLevel(String var1, String var2, Throwable var3);

        public final void log(CharSequence msg, Throwable t) {
            StackTraceElement element = Thread.currentThread().getStackTrace()[4];
            this.logLevel(element.getClassName(), this.stackTraceElementToMessagePrefix(element) + msg, t);
        }

        private String stackTraceElementToMessagePrefix(StackTraceElement element) {
            return element.getMethodName() + "():" + element.getLineNumber() + ": ";
        }
    }
}

