/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.format.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.wikipedia.feed.model.UtcDate;

public final class DateUtil {
    public static SimpleDateFormat getIso8601DateFormatShort() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public static SimpleDateFormat getIso8601DateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public static SimpleDateFormat getIso8601LocalDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ROOT);
    }

    public static String getFeedCardDayHeaderDate(int age) {
        return DateUtil.getDateStringWithSkeletonPattern(new UtcDate(age).baseCalendar().getTime(), "EEEE MMM d");
    }

    public static String getFeedCardDateString(@NonNull Context context, int age) {
        return DateUtil.getFeedCardDateString(context, new UtcDate(age).baseCalendar());
    }

    public static String getFeedCardDateString(@NonNull Context context, @NonNull Calendar date) {
        return DateUtil.getShortDateString(context, date.getTime());
    }

    public static String getFeedCardDateString(@NonNull Context context, @NonNull Date date) {
        return DateUtil.getShortDateString(context, date);
    }

    public static String getFeedCardShortDateString(@NonNull Calendar date) {
        return DateUtil.getExtraShortDateString(date.getTime());
    }

    public static String getMonthOnlyDateString(@NonNull Date date) {
        return DateUtil.getDateStringWithSkeletonPattern(date, "MMMM d");
    }

    public static String getMonthOnlyWithoutDayDateString(@NonNull Date date) {
        return DateUtil.getDateStringWithSkeletonPattern(date, "MMMM");
    }

    private static String getExtraShortDateString(@NonNull Date date) {
        return DateUtil.getDateStringWithSkeletonPattern(date, "MMM d");
    }

    private static String getDateStringWithSkeletonPattern(@NonNull Date date, @NonNull String pattern) {
        return new SimpleDateFormat(DateFormat.getBestDateTimePattern((Locale)Locale.getDefault(), (String)pattern), Locale.getDefault()).format(date);
    }

    public static String getShortDateString(@NonNull Context context, @NonNull Date date) {
        java.text.DateFormat dateFormat = DateFormat.getMediumDateFormat((Context)context);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static UtcDate getUtcRequestDateFor(int age) {
        return new UtcDate(age);
    }

    public static Calendar getDefaultDateFor(int age) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.add(5, -age);
        return calendar;
    }

    public static Date getHttpLastModifiedDate(@NonNull String dateStr) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.parse(dateStr);
    }

    public static String getReadingListsLastSyncDateString(@NonNull String dateStr) throws ParseException {
        return DateUtil.getDateStringWithSkeletonPattern(DateUtil.getIso8601DateFormat().parse(dateStr), "d MMM yyyy HH:mm");
    }

    @NonNull
    public static String yearToStringWithEra(int year) {
        GregorianCalendar cal = new GregorianCalendar(year, 1, 1);
        return DateUtil.getDateStringWithSkeletonPattern(cal.getTime(), year < 0 ? "y GG" : "y");
    }

    private DateUtil() {
    }
}

