/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.page;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Locale;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.page.Namespace;
import org.wikipedia.page.PageProperties;
import org.wikipedia.util.StringUtil;
import org.wikipedia.util.UriUtil;

public class PageTitle
implements Parcelable {
    public static final Parcelable.Creator<PageTitle> CREATOR = new Parcelable.Creator<PageTitle>(){

        public PageTitle createFromParcel(Parcel in) {
            return new PageTitle(in);
        }

        public PageTitle[] newArray(int size) {
            return new PageTitle[size];
        }
    };
    @Nullable
    private final String namespace;
    @NonNull
    private final String text;
    @Nullable
    private final String fragment;
    @Nullable
    private String thumbUrl;
    @SerializedName(value="site")
    @NonNull
    private final WikiSite wiki;
    @Nullable
    private String description;
    @Nullable
    private final PageProperties properties;
    @Nullable
    private String convertedText;

    public static PageTitle withSeparateFragment(@NonNull String prefixedText, @Nullable String fragment, @NonNull WikiSite wiki) {
        if (TextUtils.isEmpty((CharSequence)fragment)) {
            return new PageTitle(prefixedText, wiki, null, (PageProperties)null);
        }
        return new PageTitle(prefixedText + "#" + fragment, wiki, null, (PageProperties)null);
    }

    public PageTitle(@Nullable String namespace, @NonNull String text, @Nullable String fragment, @Nullable String thumbUrl, @NonNull WikiSite wiki) {
        this.namespace = namespace;
        this.text = text;
        this.fragment = fragment;
        this.wiki = wiki;
        this.thumbUrl = thumbUrl;
        this.properties = null;
    }

    public PageTitle(@Nullable String text, @NonNull WikiSite wiki, @Nullable String thumbUrl, @Nullable String description, @Nullable PageProperties properties) {
        this(text, wiki, thumbUrl, properties);
        this.description = description;
    }

    public PageTitle(@Nullable String text, @NonNull WikiSite wiki, @Nullable String thumbUrl, @Nullable String description) {
        this(text, wiki, thumbUrl);
        this.description = description;
    }

    public PageTitle(@Nullable String namespace, @NonNull String text, @NonNull WikiSite wiki) {
        this(namespace, text, null, null, wiki);
    }

    public PageTitle(@Nullable String text, @NonNull WikiSite wiki, @Nullable String thumbUrl) {
        this(text, wiki, thumbUrl, (PageProperties)null);
    }

    public PageTitle(@Nullable String text, @NonNull WikiSite wiki) {
        this(text, wiki, null);
    }

    private PageTitle(@Nullable String text, @NonNull WikiSite wiki, @Nullable String thumbUrl, @Nullable PageProperties properties) {
        String[] fragParts = text.split("#", -1);
        text = fragParts[0];
        this.fragment = fragParts.length > 1 ? UriUtil.decodeURL(fragParts[1]).replace(" ", "_") : null;
        String[] parts = text.split(":", -1);
        if (parts.length > 1) {
            String namespaceOrLanguage = parts[0];
            if (Arrays.asList(Locale.getISOLanguages()).contains(namespaceOrLanguage)) {
                this.namespace = null;
                this.wiki = new WikiSite(wiki.authority(), namespaceOrLanguage);
            } else {
                this.wiki = wiki;
                this.namespace = namespaceOrLanguage;
            }
            this.text = TextUtils.join((CharSequence)":", (Object[])Arrays.copyOfRange(parts, 1, parts.length));
        } else {
            this.wiki = wiki;
            this.namespace = null;
            this.text = parts[0];
        }
        this.thumbUrl = thumbUrl;
        this.properties = properties;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @NonNull
    public Namespace namespace() {
        if (this.properties != null) {
            return this.properties.getNamespace();
        }
        return Namespace.fromLegacyString(this.wiki, this.namespace);
    }

    @NonNull
    public WikiSite getWikiSite() {
        return this.wiki;
    }

    @NonNull
    public String getText() {
        return this.text.replace(" ", "_");
    }

    @Nullable
    public String getFragment() {
        return this.fragment;
    }

    @Nullable
    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(@Nullable String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NonNull
    public String getConvertedText() {
        return this.convertedText == null ? this.getPrefixedText() : this.convertedText;
    }

    public void setConvertedText(@Nullable String convertedText) {
        this.convertedText = convertedText;
    }

    @NonNull
    public String getDisplayText() {
        return this.getPrefixedText().replace("_", " ");
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    @Nullable
    public PageProperties getProperties() {
        return this.properties;
    }

    public boolean isMainPage() {
        return this.properties != null && this.properties.isMainPage();
    }

    public boolean isDisambiguationPage() {
        return this.properties != null && this.properties.isDisambiguationPage();
    }

    public String getCanonicalUri() {
        return this.getUriForDomain(this.getWikiSite().authority());
    }

    public String getMobileUri() {
        return this.getUriForDomain(this.getWikiSite().mobileAuthority());
    }

    public String getUriForAction(String action) {
        try {
            return String.format("%1$s://%2$s/w/index.php?title=%3$s&action=%4$s", this.getWikiSite().scheme(), this.getWikiSite().authority(), URLEncoder.encode(this.getPrefixedText(), "utf-8"), action);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPrefixedText() {
        return this.namespace == null ? this.getText() : StringUtil.addUnderscores(this.namespace) + ":" + this.getText();
    }

    public boolean isFilePage() {
        return this.namespace().file();
    }

    public boolean isSpecial() {
        return this.namespace().special();
    }

    public boolean isTalkPage() {
        return this.namespace().talk();
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.namespace);
        parcel.writeString(this.text);
        parcel.writeString(this.fragment);
        parcel.writeParcelable((Parcelable)this.wiki, flags);
        parcel.writeParcelable((Parcelable)this.properties, flags);
        parcel.writeString(this.thumbUrl);
        parcel.writeString(this.description);
        parcel.writeString(this.convertedText);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PageTitle)) {
            return false;
        }
        PageTitle other = (PageTitle)o;
        return StringUtil.normalizedEquals(other.getPrefixedText(), this.getPrefixedText()) && other.wiki.equals(this.wiki);
    }

    public int hashCode() {
        int result = this.getPrefixedText().hashCode();
        result = 31 * result + this.wiki.hashCode();
        return result;
    }

    public String toString() {
        return this.getPrefixedText();
    }

    public int describeContents() {
        return 0;
    }

    private String getUriForDomain(String domain) {
        try {
            return String.format("%1$s://%2$s/wiki/%3$s%4$s", this.getWikiSite().scheme(), domain, URLEncoder.encode(this.getPrefixedText(), "utf-8"), this.fragment != null && this.fragment.length() > 0 ? "#" + this.fragment : "");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private PageTitle(Parcel in) {
        this.namespace = in.readString();
        this.text = in.readString();
        this.fragment = in.readString();
        this.wiki = (WikiSite)in.readParcelable(WikiSite.class.getClassLoader());
        this.properties = (PageProperties)in.readParcelable(PageProperties.class.getClassLoader());
        this.thumbUrl = in.readString();
        this.description = in.readString();
        this.convertedText = in.readString();
    }
}

