/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.gallery;

import android.support.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.gallery.ExtMetadata;

public class ImageLicense
implements Serializable {
    private static final String CREATIVE_COMMONS_PREFIX = "cc";
    private static final String PUBLIC_DOMAIN_PREFIX = "pd";
    private static final String CC_BY_SA = "ccbysa";
    @SerializedName(value="type")
    @NonNull
    private final String license;
    @SerializedName(value="code")
    @NonNull
    private final String licenseShortName;
    @SerializedName(value="url")
    @NonNull
    private final String licenseUrl;

    public ImageLicense(@NonNull ExtMetadata metadata) {
        this.license = metadata.license() != null ? metadata.license().value() : "";
        this.licenseShortName = metadata.licenseShortName() != null ? metadata.licenseShortName().value() : "";
        this.licenseUrl = metadata.licenseUrl() != null ? metadata.licenseUrl().value() : "";
    }

    private ImageLicense(@NonNull String license, @NonNull String licenseShortName, @NonNull String licenseUrl) {
        this.license = license;
        this.licenseShortName = licenseShortName;
        this.licenseUrl = licenseUrl;
    }

    public ImageLicense() {
        this("", "", "");
    }

    @NonNull
    public String getLicenseName() {
        return this.license;
    }

    @NonNull
    public String getLicenseShortName() {
        return this.licenseShortName;
    }

    @NonNull
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    private boolean isLicenseCC() {
        return StringUtils.defaultString((String)this.license).toLowerCase(Locale.ENGLISH).startsWith(CREATIVE_COMMONS_PREFIX) || StringUtils.defaultString((String)this.licenseShortName).toLowerCase(Locale.ENGLISH).startsWith(CREATIVE_COMMONS_PREFIX);
    }

    private boolean isLicensePD() {
        return StringUtils.defaultString((String)this.license).toLowerCase(Locale.ENGLISH).startsWith(PUBLIC_DOMAIN_PREFIX) || StringUtils.defaultString((String)this.licenseShortName).toLowerCase(Locale.ENGLISH).startsWith(PUBLIC_DOMAIN_PREFIX);
    }

    private boolean isLicenseCCBySa() {
        return StringUtils.defaultString((String)this.license).toLowerCase(Locale.ENGLISH).replace("-", "").startsWith(CC_BY_SA) || StringUtils.defaultString((String)this.licenseShortName).toLowerCase(Locale.ENGLISH).replace("-", "").startsWith(CC_BY_SA);
    }

    public boolean hasLicenseInfo() {
        return !this.license.isEmpty() || !this.licenseShortName.isEmpty() || !this.licenseUrl.isEmpty();
    }
}

