/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.mwapi.page;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import org.wikipedia.dataclient.mwapi.MwQueryPage;
import org.wikipedia.dataclient.mwapi.MwResponse;
import org.wikipedia.dataclient.page.PageLead;
import org.wikipedia.dataclient.page.PageLeadProperties;
import org.wikipedia.dataclient.page.Protection;
import org.wikipedia.page.Namespace;
import org.wikipedia.page.Page;
import org.wikipedia.page.PageProperties;
import org.wikipedia.page.PageTitle;
import org.wikipedia.page.Section;
import org.wikipedia.util.ImageUrlUtil;
import org.wikipedia.util.StringUtil;
import org.wikipedia.util.UriUtil;

public class MwMobileViewPageLead
extends MwResponse
implements PageLead {
    private Mobileview mobileview;

    @Override
    public Page toPage(@NonNull PageTitle title) {
        return new Page(this.adjustPageTitle(title, title.getPrefixedText()), this.mobileview.getSections(), this.mobileview.toPageProperties());
    }

    private PageTitle adjustPageTitle(@NonNull PageTitle title, @NonNull String originalPrefixedText) {
        if (this.mobileview.getRedirected() != null) {
            title = new PageTitle(this.mobileview.getRedirected(), title.getWikiSite(), title.getThumbUrl());
        } else if (this.mobileview.getNormalizedTitle() != null) {
            title = new PageTitle(this.mobileview.getNormalizedTitle(), title.getWikiSite(), title.getThumbUrl());
        }
        if (this.mobileview.getDisplayTitle() != null && !StringUtil.removeHTMLTags(title.getDisplayText()).equals(StringUtil.removeHTMLTags(this.mobileview.getDisplayTitle()))) {
            title = new PageTitle(StringUtil.removeHTMLTags(this.mobileview.getDisplayTitle()), title.getWikiSite(), title.getThumbUrl());
        }
        if (this.mobileview.getDisplayTitle() != null && !this.mobileview.getDisplayTitle().equals(originalPrefixedText) && this.mobileview.getNormalizedTitle() == null) {
            title = new PageTitle(originalPrefixedText, title.getWikiSite(), title.getThumbUrl());
        }
        title.setDescription(this.mobileview.getDescription());
        return title;
    }

    @Override
    @NonNull
    public String getLeadSectionContent() {
        if (this.mobileview != null) {
            return this.mobileview.getSections().get(0).getContent();
        }
        return "";
    }

    @Override
    @Nullable
    public String getTitlePronunciationUrl() {
        return null;
    }

    @Override
    @Nullable
    public String getLeadImageUrl(int leadImageWidth) {
        return this.mobileview == null ? null : this.mobileview.getLeadImageUrl(leadImageWidth);
    }

    @Override
    @Nullable
    public String getThumbUrl() {
        return this.mobileview == null ? null : this.mobileview.getThumbUrl();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.mobileview == null ? null : this.mobileview.getDescription();
    }

    @Override
    @Nullable
    public Location getGeo() {
        return null;
    }

    @VisibleForTesting
    public Mobileview getMobileview() {
        return this.mobileview;
    }

    public static class PageImageThumb {
        private String url;

        public String getUrl() {
            return this.url;
        }
    }

    public static class PageImage {
        @SerializedName(value="file")
        private String fileName;

        public String getFileName() {
            return this.fileName;
        }
    }

    public static class Mobileview
    implements PageLeadProperties {
        private int id;
        private int namespace;
        private long revision;
        @Nullable
        private String lastmodified;
        @Nullable
        private String displaytitle;
        @Nullable
        private String redirected;
        @Nullable
        private String normalizedtitle;
        private int languagecount;
        private boolean editable;
        private boolean mainpage;
        private boolean disambiguation;
        @Nullable
        private String description;
        @Nullable
        private String descriptionsource;
        @SerializedName(value="image")
        @Nullable
        private PageImage pageImage;
        @SerializedName(value="thumb")
        @Nullable
        private PageImageThumb leadImage;
        @Nullable
        private Protection protection;
        @Nullable
        private List<Section> sections;
        @Nullable
        private MwQueryPage.PageProps pageprops;

        public PageProperties toPageProperties() {
            return new PageProperties(this);
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        @NonNull
        public Namespace getNamespace() {
            return Namespace.of(this.namespace);
        }

        @Override
        public long getRevision() {
            return this.revision;
        }

        @Override
        @Nullable
        public String getLastModified() {
            return this.lastmodified;
        }

        @Override
        public int getLanguageCount() {
            return this.languagecount;
        }

        @Override
        @Nullable
        public String getDisplayTitle() {
            return this.displaytitle;
        }

        @Override
        @Nullable
        public String getTitlePronunciationUrl() {
            return null;
        }

        @Override
        @Nullable
        public Location getGeo() {
            return null;
        }

        @Override
        @Nullable
        public String getRedirected() {
            return this.redirected;
        }

        @Override
        @Nullable
        public String getNormalizedTitle() {
            return this.normalizedtitle;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        @Nullable
        public String getLeadImageUrl(int leadImageWidth) {
            return this.leadImage != null ? this.leadImage.getUrl() : null;
        }

        @Override
        @Nullable
        public String getThumbUrl() {
            return this.leadImage != null ? UriUtil.resolveProtocolRelativeUrl(ImageUrlUtil.getUrlForSize(this.leadImage.getUrl(), 320)) : null;
        }

        @Override
        @Nullable
        public String getLeadImageFileName() {
            return this.pageImage != null ? this.pageImage.getFileName() : null;
        }

        @Override
        @Nullable
        public String getWikiBaseItem() {
            return this.pageprops != null && this.pageprops.getWikiBaseItem() != null ? this.pageprops.getWikiBaseItem() : null;
        }

        @Override
        @Nullable
        public String getDescriptionSource() {
            return this.descriptionsource;
        }

        @Override
        @Nullable
        public String getFirstAllowedEditorRole() {
            return this.protection != null ? this.protection.getFirstAllowedEditorRole() : null;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        @Override
        public boolean isMainPage() {
            return this.mainpage;
        }

        @Override
        public boolean isDisambiguation() {
            return this.disambiguation;
        }

        @Override
        @NonNull
        public List<Section> getSections() {
            return this.sections == null ? Collections.emptyList() : this.sections;
        }
    }
}

