/*
 * Decompiled with CFR 0.152.
 */
package com.dld.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.dld.view.ISegmentedControl;
import com.dld.view.R;
import com.dld.view.SegmentedControlItem;
import com.dld.view.SelectedItemState;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class SegmentedControlView
extends View
implements ISegmentedControl {
    private static final int VELOCITY_UNITS = 1000;
    private static final int ANIMATION_DURATION = 300;
    private static final int MOVE_ITEM_MIN_VELOCITY = 1500;
    private static final int DEFAULT_RADIUS = 10;
    private static final int DEFAULT_OUTER_COLOR = Color.parseColor((String)"#12B7F5");
    private static final int DEFAULT_ITEM_COLOR = -1;
    private static final int DEFAULT_TEXT_COLOR = -1;
    private static final int DEFAULT_SELECTED_TEXT_COLOR = Color.parseColor((String)"#00A5E0");
    private static final float MIN_MOVE_X = 5.0f;
    private static final float VELOCITY_CHANGE_POSITION_THRESHOLD = 0.25f;
    public static final int Round = 0;
    public static final int Circle = 1;
    private int cornersRadius;
    private int backgroundColor;
    private int itemHorizontalMargin;
    private int itemVerticalMargin;
    private int selectedItemBackgroundColor;
    private int textSize;
    private int textColor;
    private int selectedItemTextColor;
    private int selectedItem;
    private int cornersMode = 0;
    private boolean scrollSelectEnabled = true;
    private OnSegItemClickListener onSegItemClickListener;
    private int mStart;
    private int mEnd;
    private int mHeight;
    private int mItemWidth;
    private int onClickDownPosition = -1;
    private int mMaximumFlingVelocity;
    private float x = 0.0f;
    private RectF mRectF;
    private Paint mPaint;
    private Paint mTextPaint;
    private Scroller mScroller;
    private VelocityTracker mVelocityTracker;
    private List<SegmentedControlItem> mSegmentedControlItems = new ArrayList<SegmentedControlItem>();

    public SegmentedControlView(Context context) {
        this(context, null);
    }

    public SegmentedControlView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SegmentedControlView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SegmentedControlView);
        this.cornersRadius = ta.getDimensionPixelSize(R.styleable.SegmentedControlView_segCornersRadius, 10);
        this.backgroundColor = ta.getColor(R.styleable.SegmentedControlView_segBackgroundColor, DEFAULT_OUTER_COLOR);
        this.selectedItemBackgroundColor = ta.getColor(R.styleable.SegmentedControlView_segSelectedItemBackgroundColor, -1);
        this.textColor = ta.getColor(R.styleable.SegmentedControlView_segTextColor, -1);
        this.selectedItemTextColor = ta.getColor(R.styleable.SegmentedControlView_segSelectedItemTextColor, DEFAULT_SELECTED_TEXT_COLOR);
        this.itemHorizontalMargin = ta.getDimensionPixelSize(R.styleable.SegmentedControlView_segItemHorizontalMargin, 0);
        this.itemVerticalMargin = ta.getDimensionPixelSize(R.styleable.SegmentedControlView_segItemVerticalMargin, 0);
        this.selectedItem = ta.getInteger(R.styleable.SegmentedControlView_segSelectedItem, 0);
        this.textSize = ta.getDimensionPixelSize(R.styleable.SegmentedControlView_segTextSize, (int)this.getResources().getDimension(R.dimen.seg_textSize));
        this.cornersMode = ta.getInt(R.styleable.SegmentedControlView_segCornersMode, 0);
        this.scrollSelectEnabled = ta.getBoolean(R.styleable.SegmentedControlView_segScrollSelectEnabled, true);
        ta.recycle();
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
        this.mScroller = new Scroller(context, (Interpolator)new FastOutSlowInInterpolator());
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mRectF = new RectF();
        this.mPaint = new Paint(5);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.backgroundColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        this.mTextPaint = new Paint(5);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(this.textColor);
        this.mTextPaint.setTextSize((float)this.textSize);
    }

    public void setCornersMode(@Mode int mode) {
        this.cornersMode = mode;
        this.invalidate();
    }

    public void setTextColor(int color) {
        this.textColor = color;
        this.invalidate();
    }

    public void setSelectedItemTextColor(int color) {
        this.selectedItemTextColor = color;
        this.invalidate();
    }

    public void setSelectedItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            throw new IllegalArgumentException("position error");
        }
        this.selectedItem = position;
        this.invalidate();
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public int getCornersMode() {
        return this.cornersMode;
    }

    public boolean isScrollSelectEnabled() {
        return this.scrollSelectEnabled;
    }

    public void setOnSegItemClickListener(OnSegItemClickListener onSegItemClickListener) {
        this.onSegItemClickListener = onSegItemClickListener;
    }

    public void addItems(List<SegmentedControlItem> list) {
        if (list == null) {
            throw new IllegalArgumentException("list is null");
        }
        this.mSegmentedControlItems.addAll(list);
        this.requestLayout();
        this.invalidate();
    }

    public void addItem(SegmentedControlItem item) {
        if (item == null) {
            throw new IllegalArgumentException("item is null");
        }
        this.mSegmentedControlItems.add(item);
        this.requestLayout();
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isItemZero()) {
            return;
        }
        this.drawBackgroundRect(canvas);
        this.drawUnselectedItemsText(canvas);
        this.drawSelectedItem(canvas);
        this.drawSelectedItemsText(canvas);
    }

    private void drawSelectedItem(Canvas canvas) {
        float r = this.cornersMode == 0 ? (float)this.cornersRadius : (float)((this.mHeight >> 1) - this.itemVerticalMargin);
        this.mPaint.setColor(this.selectedItemBackgroundColor);
        this.mRectF.set((float)this.mStart, (float)this.itemVerticalMargin, (float)(this.mStart + this.mItemWidth), (float)(this.getHeight() - this.itemVerticalMargin));
        canvas.drawRoundRect(this.mRectF, r, r, this.mPaint);
    }

    private void drawBackgroundRect(Canvas canvas) {
        float r = this.cornersMode == 0 ? (float)this.cornersRadius : (float)(this.mHeight >> 1);
        this.mPaint.setXfermode(null);
        this.mPaint.setColor(this.backgroundColor);
        this.mRectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        canvas.drawRoundRect(this.mRectF, r, r, this.mPaint);
    }

    private void drawUnselectedItemsText(Canvas canvas) {
        this.mTextPaint.setColor(this.textColor);
        this.mTextPaint.setXfermode(null);
        for (int i = 0; i < this.getCount(); ++i) {
            int start = this.itemHorizontalMargin + i * this.mItemWidth;
            float x = (float)(start + (this.mItemWidth >> 1)) - this.mTextPaint.measureText(this.getName(i)) / 2.0f;
            float y = (float)(this.getHeight() >> 1) - (this.mTextPaint.ascent() + this.mTextPaint.descent()) / 2.0f;
            canvas.drawText(this.getName(i), x, y, this.mTextPaint);
        }
    }

    private void drawSelectedItemsText(Canvas canvas) {
        canvas.saveLayer((float)this.mStart, 0.0f, (float)(this.mStart + this.mItemWidth), (float)this.getHeight(), null, 31);
        this.mTextPaint.setColor(this.selectedItemTextColor);
        this.mTextPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        int begin = this.mStart / this.mItemWidth;
        int end = begin + 2 < this.getCount() ? begin + 2 : this.getCount();
        for (int i = begin; i < end; ++i) {
            int start = this.itemHorizontalMargin + i * this.mItemWidth;
            float x = (float)(start + (this.mItemWidth >> 1)) - this.mTextPaint.measureText(this.getName(i)) / 2.0f;
            float y = (float)(this.getHeight() >> 1) - (this.mTextPaint.ascent() + this.mTextPaint.descent()) / 2.0f;
            canvas.drawText(this.getName(i), x, y, this.mTextPaint);
        }
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || !this.isInTouchMode() || this.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int action = event.getActionMasked();
        if (action == 0) {
            this.x = event.getX();
            this.onClickDownPosition = -1;
            float y = event.getY();
            if (this.isItemInside(this.x, y)) {
                return this.scrollSelectEnabled;
            }
            if (this.isItemOutside(this.x, y)) {
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.onClickDownPosition = (int)((this.x - (float)this.itemHorizontalMargin) / (float)this.mItemWidth);
                this.startScroll(this.positionStart(this.x));
                return true;
            }
            return false;
        }
        if (action == 2) {
            if (!this.mScroller.isFinished() || !this.scrollSelectEnabled) {
                return true;
            }
            float dx = event.getX() - this.x;
            if (Math.abs(dx) > 5.0f) {
                this.mStart = (int)((float)this.mStart + dx);
                this.mStart = Math.min(Math.max(this.mStart, this.itemHorizontalMargin), this.mEnd);
                this.postInvalidate();
                this.x = event.getX();
            }
            return true;
        }
        if (action == 1) {
            int newSelectedItem;
            float offset = (this.mStart - this.itemHorizontalMargin) % this.mItemWidth;
            float itemStartPosition = (float)(this.mStart - this.itemHorizontalMargin) * 1.0f / (float)this.mItemWidth;
            if (!this.mScroller.isFinished() && this.onClickDownPosition != -1) {
                newSelectedItem = this.onClickDownPosition;
            } else if (offset == 0.0f) {
                newSelectedItem = (int)itemStartPosition;
            } else {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                int initialVelocity = (int)velocityTracker.getXVelocity();
                float itemRate = offset / (float)this.mItemWidth;
                newSelectedItem = this.isXVelocityCanMoveNextItem(initialVelocity, itemRate) ? (initialVelocity > 0 ? (int)itemStartPosition + 1 : (int)itemStartPosition) : Math.round(itemStartPosition);
                newSelectedItem = Math.max(Math.min(newSelectedItem, this.getCount() - 1), 0);
                this.startScroll(this.getXByPosition(newSelectedItem));
            }
            this.onStateChange(newSelectedItem);
            this.mVelocityTracker = null;
            this.onClickDownPosition = -1;
            return true;
        }
        return super.onTouchEvent(event);
    }

    private void startScroll(int dx) {
        this.mScroller.startScroll(this.mStart, 0, dx - this.mStart, 0, 300);
        this.postInvalidate();
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            this.mStart = this.mScroller.getCurrX();
            this.postInvalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isItemZero() || this.getMeasuredWidth() == 0) {
            return;
        }
        this.mHeight = this.getMeasuredHeight();
        int width = this.getMeasuredWidth();
        this.mItemWidth = (width - 2 * this.itemHorizontalMargin) / this.getCount();
        this.mStart = this.itemHorizontalMargin + this.mItemWidth * this.selectedItem;
        this.mEnd = width - this.itemHorizontalMargin - this.mItemWidth;
    }

    private void onStateChange(int selectedItem) {
        if (this.selectedItem != selectedItem) {
            this.selectedItem = selectedItem;
            this.onItemClick(this.getItem(selectedItem), selectedItem);
        }
    }

    private void onItemClick(SegmentedControlItem item, int position) {
        if (null != this.onSegItemClickListener) {
            this.onSegItemClickListener.onItemClick(item, position);
        }
    }

    private int getXByPosition(int item) {
        return item * this.mItemWidth + this.itemHorizontalMargin;
    }

    private int positionStart(float x) {
        return this.itemHorizontalMargin + (int)((x - (float)this.itemHorizontalMargin) / (float)this.mItemWidth) * this.mItemWidth;
    }

    private boolean isItemInside(float x, float y) {
        return x >= (float)this.mStart && x <= (float)(this.mStart + this.mItemWidth) && y > (float)this.itemVerticalMargin && y < (float)(this.mHeight - this.itemVerticalMargin);
    }

    private boolean isItemOutside(float x, float y) {
        return !this.isItemInside(x, y) && y > (float)this.itemVerticalMargin && y < (float)(this.mHeight - this.itemVerticalMargin) && x < (float)(this.mEnd + this.mItemWidth);
    }

    private boolean isXVelocityCanMoveNextItem(int xVelocity, float dxItemRate) {
        return Math.abs(xVelocity) > 1500 && (xVelocity > 0 && dxItemRate >= 0.25f || xVelocity < 0 && dxItemRate < 0.75f);
    }

    private boolean isItemZero() {
        return this.getCount() == 0;
    }

    @Override
    public int getCount() {
        return this.mSegmentedControlItems.size();
    }

    @Override
    public SegmentedControlItem getItem(int position) {
        return this.mSegmentedControlItems.get(position);
    }

    @Override
    public String getName(int position) {
        return this.getItem(position).getName();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        SelectedItemState pullToLoadState = new SelectedItemState(parcelable);
        pullToLoadState.setSelectedItem(this.selectedItem);
        return pullToLoadState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SelectedItemState)) {
            return;
        }
        SelectedItemState pullToLoadState = (SelectedItemState)state;
        super.onRestoreInstanceState(pullToLoadState.getSuperState());
        this.selectedItem = pullToLoadState.getSelectedItem();
        this.invalidate();
    }

    public static interface OnSegItemClickListener {
        public void onItemClick(SegmentedControlItem var1, int var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Mode {
    }
}

