/*
 * Decompiled with CFR 0.152.
 */
package com.dk.view.patheffect;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import com.dk.view.patheffect.MatchPath;
import java.util.ArrayList;

public class PathTextView
extends View {
    private static final float BASE_SQUARE_UNIT = 72.0f;
    private String mText = "FUCK";
    private ArrayList<float[]> mDatas;
    private ArrayList<Path> mPaths = new ArrayList();
    private Paint mPaint = new Paint();
    private ObjectAnimator mSvgAnimator;
    private final Object mSvgLock = new Object();
    private float mPhase;
    private Type mType = Type.SINGLE;
    private float mScaleFactor = 1.0f;
    private int mTextColor = -16777216;
    private float mTextSize = 72.0f;
    private float mTextWeight = 2.0f;
    private float mShadowDy = 0.0f;
    private int mDuration = 3000;

    public PathTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mTextColor);
        this.mPaint.setStrokeWidth(this.mTextWeight);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, this.mPaint);
        }
    }

    public void setTextColor(int color) {
        this.mTextColor = color;
        this.mPaint.setColor(color);
    }

    public void setTextWeight(int weight) {
        this.mTextWeight = weight;
        this.mPaint.setStrokeWidth(this.mTextWeight);
    }

    public void setTextSize(float size) {
        this.mTextSize = size;
        this.mScaleFactor = this.mTextSize / 72.0f;
    }

    public void setPaintType(Type type) {
        this.mType = type;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void setShadow(int radius, int dx, int dy, int color) {
        this.mShadowDy = dy;
        this.mPaint.setShadowLayer((float)radius, (float)dx, (float)dy, color);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    public void init(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.requestLayout();
        this.invalidate();
        this.mText = text;
        this.mDatas = MatchPath.getPath(this.mText);
        this.mSvgAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"phase", (float[])new float[]{0.0f, 1.0f}).setDuration((long)this.mDuration);
        this.mSvgAnimator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPaths == null) {
            return;
        }
        Object object = this.mSvgLock;
        synchronized (object) {
            for (int i = 0; i < this.mPaths.size(); ++i) {
                canvas.drawPath(this.mPaths.get(i), this.mPaint);
            }
        }
    }

    private void updatePathsPhaseLocked() {
        this.mPaths.clear();
        float singlefactor = this.mPhase * (float)this.mDatas.size();
        for (int i = 0; i < this.mDatas.size(); ++i) {
            Path path = new Path();
            path.moveTo(this.mDatas.get(i)[0] * this.mScaleFactor + this.mTextWeight, this.mDatas.get(i)[1] * this.mScaleFactor + this.mTextWeight);
            path.lineTo(this.mDatas.get(i)[2] * this.mScaleFactor + this.mTextWeight, this.mDatas.get(i)[3] * this.mScaleFactor + this.mTextWeight);
            if (this.mType == Type.MULTIPLY) {
                PathMeasure measure = new PathMeasure(path, false);
                Path dst = new Path();
                measure.getSegment(0.0f, this.mPhase * measure.getLength(), dst, true);
                this.mPaths.add(dst);
                continue;
            }
            if ((double)(singlefactor - (float)(i + 1)) >= -0.01) {
                this.mPaths.add(path);
                continue;
            }
            if (!((double)i - Math.floor(singlefactor) < 1.0E-4)) continue;
            Path dst = new Path();
            PathMeasure measure = new PathMeasure(path, false);
            measure.getSegment(0.0f, singlefactor % 1.0f * measure.getLength(), dst, true);
            this.mPaths.add(dst);
        }
    }

    public float getPhase() {
        return this.mPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhase(float phase) {
        this.mPhase = phase;
        Object object = this.mSvgLock;
        synchronized (object) {
            this.updatePathsPhaseLocked();
        }
        this.invalidate();
    }

    private int measureWidth(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = (int)((float)this.mText.length() * 72.0f * this.mScaleFactor + (float)this.getPaddingLeft() + (float)this.getPaddingRight() + this.mTextWeight * 2.0f);
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = (int)(72.0f * this.mScaleFactor) + this.getPaddingTop() + this.getPaddingBottom() + (int)(this.mTextWeight * 2.0f) + (int)this.mShadowDy;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    public static enum Type {
        SINGLE,
        MULTIPLY;

    }
}

