/*
 * Decompiled with CFR 0.152.
 */
package com.dk.image.process.radialblur;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;

public class RadialBlur {
    public static Bitmap doRadialBlur(Bitmap src, int dx, int dy) {
        return RadialBlur.doRadialBlur(src, dx, dy, 20);
    }

    public static Bitmap doRadialBlur(Bitmap src, int dx, int dy, int times) {
        Bitmap dst = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(dst);
        Matrix matrix = new Matrix();
        Paint paint = new Paint();
        canvas.drawBitmap(src, matrix, paint);
        paint.setAlpha(51);
        for (int i = 0; i < times; ++i) {
            matrix.setTranslate((float)(i * dx), (float)(i * dy));
            canvas.drawBitmap(src, matrix, paint);
        }
        return dst;
    }

    public static Bitmap doRadialBlur(Bitmap src, int centerX, int centerY, float factor) {
        return RadialBlur.doRadialBlur(src, centerX, centerY, factor, 20);
    }

    public static Bitmap doRadialBlur(Bitmap src, int centerX, int centerY, float factor, int times) {
        Bitmap dst = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(dst);
        Matrix matrix = new Matrix();
        Paint paint = new Paint();
        canvas.drawBitmap(src, matrix, paint);
        paint.setAlpha(51);
        long start = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            matrix.setScale((float)i * factor + 1.0f, (float)i * factor + 1.0f, (float)centerX, (float)centerY);
            canvas.drawBitmap(src, matrix, paint);
        }
        System.out.println(System.currentTimeMillis() - start);
        return dst;
    }
}

