/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.JvmBuffer;
import com.ditchoom.buffer.ManagedMemoryAccess;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0000H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/ditchoom/buffer/HeapJvmBuffer;", "Lcom/ditchoom/buffer/JvmBuffer;", "Lcom/ditchoom/buffer/ManagedMemoryAccess;", "byteBuffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "backingArray", "", "getBackingArray", "()[B", "arrayOffset", "", "getArrayOffset", "()I", "slice", "buffer_release"})
@SourceDebugExtension(value={"SMAP\nHeapJvmBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapJvmBuffer.kt\ncom/ditchoom/buffer/HeapJvmBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class HeapJvmBuffer
extends JvmBuffer
implements ManagedMemoryAccess {
    public HeapJvmBuffer(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        super(byteBuffer);
        if (!byteBuffer.hasArray()) {
            boolean bl = false;
            String string = "HeapJvmBuffer requires a heap ByteBuffer with backing array";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public byte[] getBackingArray() {
        byte[] byArray = this.getByteBuffer().array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @Override
    public int getArrayOffset() {
        ByteBuffer byteBuffer = this.getByteBuffer();
        Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).arrayOffset();
    }

    @Override
    @NotNull
    public HeapJvmBuffer slice() {
        ByteBuffer byteBuffer = this.getByteBuffer().slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
        return new HeapJvmBuffer(byteBuffer);
    }
}

