/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer.pool;

import com.ditchoom.buffer.AllocationZone;
import com.ditchoom.buffer.BufferFactoryAndroid;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.PlatformBuffer;
import com.ditchoom.buffer.pool.BufferPool;
import com.ditchoom.buffer.pool.PoolStats;
import com.ditchoom.buffer.pool.PooledBuffer;
import com.ditchoom.buffer.pool.SimplePooledBuffer;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/ditchoom/buffer/pool/SingleThreadedBufferPool;", "Lcom/ditchoom/buffer/pool/BufferPool;", "maxPoolSize", "", "defaultBufferSize", "byteOrder", "Lcom/ditchoom/buffer/ByteOrder;", "allocationZone", "Lcom/ditchoom/buffer/AllocationZone;", "<init>", "(IILcom/ditchoom/buffer/ByteOrder;Lcom/ditchoom/buffer/AllocationZone;)V", "pool", "Lkotlin/collections/ArrayDeque;", "Lcom/ditchoom/buffer/PlatformBuffer;", "totalAllocations", "", "poolHits", "poolMisses", "peakPoolSize", "acquire", "Lcom/ditchoom/buffer/pool/PooledBuffer;", "minSize", "release", "", "buffer", "stats", "Lcom/ditchoom/buffer/pool/PoolStats;", "clear", "buffer_release"})
public final class SingleThreadedBufferPool
implements BufferPool {
    private final int maxPoolSize;
    private final int defaultBufferSize;
    @NotNull
    private final ByteOrder byteOrder;
    @NotNull
    private final AllocationZone allocationZone;
    @NotNull
    private final ArrayDeque<PlatformBuffer> pool;
    private long totalAllocations;
    private long poolHits;
    private long poolMisses;
    private int peakPoolSize;

    public SingleThreadedBufferPool(int maxPoolSize, int defaultBufferSize, @NotNull ByteOrder byteOrder, @NotNull AllocationZone allocationZone) {
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        Intrinsics.checkNotNullParameter((Object)allocationZone, (String)"allocationZone");
        this.maxPoolSize = maxPoolSize;
        this.defaultBufferSize = defaultBufferSize;
        this.byteOrder = byteOrder;
        this.allocationZone = allocationZone;
        this.pool = new ArrayDeque(this.maxPoolSize);
    }

    @Override
    @NotNull
    public PooledBuffer acquire(int minSize) {
        PooledBuffer pooledBuffer;
        long l = this.totalAllocations;
        this.totalAllocations = l + 1L;
        int size = Math.max(minSize, this.defaultBufferSize);
        PlatformBuffer buffer = (PlatformBuffer)this.pool.removeLastOrNull();
        if (buffer != null && buffer.getCapacity() >= size) {
            long l2 = this.poolHits;
            this.poolHits = l2 + 1L;
            buffer.resetForWrite();
            pooledBuffer = new SimplePooledBuffer(buffer, this);
        } else {
            long l3 = this.poolMisses;
            this.poolMisses = l3 + 1L;
            PlatformBuffer newBuffer = BufferFactoryAndroid.allocate(PlatformBuffer.Companion, size, this.allocationZone, this.byteOrder);
            pooledBuffer = new SimplePooledBuffer(newBuffer, this);
        }
        return pooledBuffer;
    }

    @Override
    public void release(@NotNull PooledBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(buffer instanceof SimplePooledBuffer)) {
            return;
        }
        if (this.pool.size() < this.maxPoolSize) {
            ((SimplePooledBuffer)buffer).getInner().resetForWrite();
            this.pool.addLast((Object)((SimplePooledBuffer)buffer).getInner());
            if (this.pool.size() > this.peakPoolSize) {
                this.peakPoolSize = this.pool.size();
            }
        }
    }

    @Override
    @NotNull
    public PoolStats stats() {
        return new PoolStats(this.totalAllocations, this.poolHits, this.poolMisses, this.pool.size(), this.peakPoolSize);
    }

    @Override
    public void clear() {
        this.pool.clear();
    }
}

