/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.BufferFactoryAndroid;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.Charset;
import com.ditchoom.buffer.PlatformBuffer;
import com.ditchoom.buffer.PositionBuffer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\n\bf\u0018\u0000 G2\u00020\u0001:\u0001GJ\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\u0011\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u00a6\u0002J\b\u0010\t\u001a\u00020\u0000H&J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\bH&J\u000f\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000f\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\b\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000f\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b&\u0010'J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020,2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000f\u0010.\u001a\u00020/H\u0016\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b3\u00104J\b\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\b2\b\b\u0002\u0010;\u001a\u00020<H&J\u0017\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\"H\u0017\u00a2\u0006\u0004\b@\u0010AJ\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\bH\u0017J\b\u0010B\u001a\u00020>H\u0016J\u0010\u0010C\u001a\u00020,2\u0006\u0010D\u001a\u00020\bH\u0016J\u0018\u0010E\u001a\u00020,2\u0006\u0010F\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bH\u0016\u00a8\u0006H"}, d2={"Lcom/ditchoom/buffer/ReadBuffer;", "Lcom/ditchoom/buffer/PositionBuffer;", "resetForRead", "", "readByte", "", "get", "index", "", "slice", "readBytes", "size", "readByteArray", "", "readUnsignedByte", "Lkotlin/UByte;", "readUnsignedByte-w2LRezQ", "()B", "getUnsignedByte", "getUnsignedByte-Wa3L5BU", "(I)B", "readShort", "", "getShort", "readUnsignedShort", "Lkotlin/UShort;", "readUnsignedShort-Mh2AYeg", "()S", "getUnsignedShort", "getUnsignedShort-BwKQO78", "(I)S", "readInt", "getInt", "readUnsignedInt", "Lkotlin/UInt;", "readUnsignedInt-pVg5ArA", "()I", "getUnsignedInt", "getUnsignedInt-OGnWXxg", "(I)I", "readFloat", "", "getFloat", "readLong", "", "getLong", "readUnsignedLong", "Lkotlin/ULong;", "readUnsignedLong-s-VKNKU", "()J", "getUnsignedLong", "getUnsignedLong-I7RO_PI", "(I)J", "readDouble", "", "getDouble", "readString", "", "length", "charset", "Lcom/ditchoom/buffer/Charset;", "readUtf8", "", "bytes", "readUtf8-WZ4Q5Ns", "(I)Ljava/lang/CharSequence;", "readUtf8Line", "readNumberWithByteSize", "numberOfBytes", "getNumberWithStartIndexAndByteSize", "startIndex", "Companion", "buffer_release"})
public interface ReadBuffer
extends PositionBuffer {
    @NotNull
    public static final Companion Companion = com.ditchoom.buffer.ReadBuffer$Companion.$$INSTANCE;

    public void resetForRead();

    public byte readByte();

    public byte get(int var1);

    @NotNull
    public ReadBuffer slice();

    @NotNull
    public ReadBuffer readBytes(int var1);

    @NotNull
    public byte[] readByteArray(int var1);

    public byte readUnsignedByte-w2LRezQ();

    public byte getUnsignedByte-Wa3L5BU(int var1);

    public short readShort();

    public short getShort(int var1);

    public short readUnsignedShort-Mh2AYeg();

    public short getUnsignedShort-BwKQO78(int var1);

    public int readInt();

    public int getInt(int var1);

    public int readUnsignedInt-pVg5ArA();

    public int getUnsignedInt-OGnWXxg(int var1);

    public float readFloat();

    public float getFloat(int var1);

    public long readLong();

    public long getLong(int var1);

    public long readUnsignedLong-s-VKNKU();

    public long getUnsignedLong-I7RO_PI(int var1);

    public double readDouble();

    public double getDouble(int var1);

    @NotNull
    public String readString(int var1, @NotNull Charset var2);

    @Deprecated(message="Use readString instead", replaceWith=@ReplaceWith(expression="readString(bytes, Charset.UTF8)", imports={"com.ditchoom.buffer.Charset"}))
    @NotNull
    public CharSequence readUtf8-WZ4Q5Ns(int var1);

    @Deprecated(message="Use readString instead", replaceWith=@ReplaceWith(expression="readString(bytes, Charset.UTF8)", imports={"com.ditchoom.buffer.Charset"}))
    @NotNull
    public CharSequence readUtf8(int var1);

    @NotNull
    public CharSequence readUtf8Line();

    public long readNumberWithByteSize(int var1);

    public long getNumberWithStartIndexAndByteSize(int var1, int var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/ditchoom/buffer/ReadBuffer$Companion;", "", "<init>", "()V", "newLine", "", "getNewLine", "()[B", "EMPTY_BUFFER", "Lcom/ditchoom/buffer/PlatformBuffer;", "getEMPTY_BUFFER", "()Lcom/ditchoom/buffer/PlatformBuffer;", "buffer_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final byte[] newLine;
        @NotNull
        private static final PlatformBuffer EMPTY_BUFFER;

        private Companion() {
        }

        @NotNull
        public final byte[] getNewLine() {
            return newLine;
        }

        @NotNull
        public final PlatformBuffer getEMPTY_BUFFER() {
            return EMPTY_BUFFER;
        }

        static {
            $$INSTANCE = new Companion();
            newLine = StringsKt.encodeToByteArray((String)"\r\n");
            EMPTY_BUFFER = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, 0, null, null, 6, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nReadBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadBuffer.kt\ncom/ditchoom/buffer/ReadBuffer$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static ReadBuffer readBytes(@NotNull ReadBuffer $this, int size) {
            if (size < 1) {
                return Companion.getEMPTY_BUFFER();
            }
            int oldLimit = $this.limit();
            int oldPosition = $this.position();
            $this.setLimit($this.position() + size);
            ReadBuffer bytes = $this.slice();
            $this.position(oldPosition + size);
            $this.setLimit(oldLimit);
            return bytes;
        }

        public static byte readUnsignedByte-w2LRezQ(@NotNull ReadBuffer $this) {
            return UByte.constructor-impl((byte)$this.readByte());
        }

        public static byte getUnsignedByte-Wa3L5BU(@NotNull ReadBuffer $this, int index) {
            return UByte.constructor-impl((byte)$this.get(index));
        }

        public static short readShort(@NotNull ReadBuffer $this) {
            return (short)$this.readNumberWithByteSize(2);
        }

        public static short getShort(@NotNull ReadBuffer $this, int index) {
            return (short)$this.getNumberWithStartIndexAndByteSize(index, 2);
        }

        public static short readUnsignedShort-Mh2AYeg(@NotNull ReadBuffer $this) {
            return UShort.constructor-impl((short)$this.readShort());
        }

        public static short getUnsignedShort-BwKQO78(@NotNull ReadBuffer $this, int index) {
            return UShort.constructor-impl((short)$this.getShort(index));
        }

        public static int readInt(@NotNull ReadBuffer $this) {
            return (int)$this.readNumberWithByteSize(4);
        }

        public static int getInt(@NotNull ReadBuffer $this, int index) {
            return (int)$this.getNumberWithStartIndexAndByteSize(index, 4);
        }

        public static int readUnsignedInt-pVg5ArA(@NotNull ReadBuffer $this) {
            return UInt.constructor-impl((int)$this.readInt());
        }

        public static int getUnsignedInt-OGnWXxg(@NotNull ReadBuffer $this, int index) {
            return UInt.constructor-impl((int)$this.getInt(index));
        }

        public static float readFloat(@NotNull ReadBuffer $this) {
            return Float.intBitsToFloat($this.readInt());
        }

        public static float getFloat(@NotNull ReadBuffer $this, int index) {
            return Float.intBitsToFloat($this.getInt(index));
        }

        public static long readLong(@NotNull ReadBuffer $this) {
            return $this.readNumberWithByteSize(8);
        }

        public static long getLong(@NotNull ReadBuffer $this, int index) {
            return $this.getNumberWithStartIndexAndByteSize(index, 8);
        }

        public static long readUnsignedLong-s-VKNKU(@NotNull ReadBuffer $this) {
            return ULong.constructor-impl((long)$this.readLong());
        }

        public static long getUnsignedLong-I7RO_PI(@NotNull ReadBuffer $this, int index) {
            return ULong.constructor-impl((long)$this.getLong(index));
        }

        public static double readDouble(@NotNull ReadBuffer $this) {
            return Double.longBitsToDouble($this.readLong());
        }

        public static double getDouble(@NotNull ReadBuffer $this, int index) {
            return Double.longBitsToDouble($this.getLong(index));
        }

        public static /* synthetic */ String readString$default(ReadBuffer readBuffer, int n, Charset charset, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readString");
            }
            if ((n2 & 2) != 0) {
                charset = Charset.UTF8;
            }
            return readBuffer.readString(n, charset);
        }

        @Deprecated(message="Use readString instead", replaceWith=@ReplaceWith(expression="readString(bytes, Charset.UTF8)", imports={"com.ditchoom.buffer.Charset"}))
        @NotNull
        public static CharSequence readUtf8-WZ4Q5Ns(@NotNull ReadBuffer $this, int bytes) {
            return $this.readString(bytes, Charset.UTF8);
        }

        @Deprecated(message="Use readString instead", replaceWith=@ReplaceWith(expression="readString(bytes, Charset.UTF8)", imports={"com.ditchoom.buffer.Charset"}))
        @NotNull
        public static CharSequence readUtf8(@NotNull ReadBuffer $this, int bytes) {
            return $this.readString(bytes, Charset.UTF8);
        }

        @NotNull
        public static CharSequence readUtf8Line(@NotNull ReadBuffer $this) {
            int initialPosition = $this.position();
            byte lastByte = 0;
            byte currentByte = 0;
            int bytesRead = 0;
            while ($this.remaining() > 0) {
                lastByte = currentByte;
                currentByte = $this.readByte();
                ++bytesRead;
                if (currentByte != Companion.getNewLine()[1]) continue;
            }
            int carriageFeedPositionIncrement = lastByte == Companion.getNewLine()[0] && currentByte == Companion.getNewLine()[1] ? 2 : (currentByte == Companion.getNewLine()[1] ? 1 : 0);
            int bytesToRead = bytesRead - carriageFeedPositionIncrement;
            $this.position(initialPosition);
            String result = $this.readString(bytesToRead, Charset.UTF8);
            $this.position($this.position() + carriageFeedPositionIncrement);
            return result;
        }

        public static long readNumberWithByteSize(@NotNull ReadBuffer $this, int numberOfBytes) {
            if (!(1 <= numberOfBytes ? numberOfBytes < 9 : false)) {
                boolean $i$a$-check-ReadBuffer$readNumberWithByteSize$22 = false;
                String $i$a$-check-ReadBuffer$readNumberWithByteSize$22 = "byte size out of range";
                throw new IllegalStateException($i$a$-check-ReadBuffer$readNumberWithByteSize$22.toString());
            }
            IntProgression byteSizeRange = switch (WhenMappings.$EnumSwitchMapping$0[$this.getByteOrder().ordinal()]) {
                case 1 -> (IntProgression)RangesKt.until((int)0, (int)numberOfBytes);
                case 2 -> RangesKt.downTo((int)(numberOfBytes - 1), (int)0);
                default -> throw new NoWhenBranchMatchedException();
            };
            long number = 0L;
            int i = byteSizeRange.getFirst();
            int n = byteSizeRange.getLast();
            int n2 = byteSizeRange.getStep();
            if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                while (true) {
                    int bitIndex = i * 8;
                    number = ((long)$this.readByte() & 0xFFL) << bitIndex | number;
                    if (i == n) break;
                    i += n2;
                }
            }
            return number;
        }

        public static long getNumberWithStartIndexAndByteSize(@NotNull ReadBuffer $this, int startIndex, int numberOfBytes) {
            if (!(1 <= numberOfBytes ? numberOfBytes < 9 : false)) {
                boolean $i$a$-check-ReadBuffer$getNumberWithStartIndexAndByteSize$22 = false;
                String $i$a$-check-ReadBuffer$getNumberWithStartIndexAndByteSize$22 = "byte size out of range";
                throw new IllegalStateException($i$a$-check-ReadBuffer$getNumberWithStartIndexAndByteSize$22.toString());
            }
            IntProgression byteSizeRange = switch (WhenMappings.$EnumSwitchMapping$0[$this.getByteOrder().ordinal()]) {
                case 1 -> (IntProgression)RangesKt.until((int)0, (int)numberOfBytes);
                case 2 -> RangesKt.downTo((int)(numberOfBytes - 1), (int)0);
                default -> throw new NoWhenBranchMatchedException();
            };
            long number = 0L;
            int index = startIndex;
            int i = byteSizeRange.getFirst();
            int n = byteSizeRange.getLast();
            int n2 = byteSizeRange.getStep();
            if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                while (true) {
                    int bitIndex = i * 8;
                    number = ((long)$this.get(index++) & 0xFFL) << bitIndex | number;
                    if (i == n) break;
                    i += n2;
                }
            }
            return number;
        }

        public static int remaining(@NotNull ReadBuffer $this) {
            return PositionBuffer.DefaultImpls.remaining($this);
        }

        public static boolean hasRemaining(@NotNull ReadBuffer $this) {
            return PositionBuffer.DefaultImpls.hasRemaining($this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ByteOrder.values().length];
            try {
                nArray[ByteOrder.LITTLE_ENDIAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ByteOrder.BIG_ENDIAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

