/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.BufferFactoryAndroid;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.Charset;
import com.ditchoom.buffer.PlatformBuffer;
import com.ditchoom.buffer.ReadBuffer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0005H\u0096\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u0014H\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0019H\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010)\u001a\u00020\u0001H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/ditchoom/buffer/TransformedReadBuffer;", "Lcom/ditchoom/buffer/ReadBuffer;", "origin", "transformer", "Lkotlin/Function2;", "", "", "(Lcom/ditchoom/buffer/ReadBuffer;Lkotlin/jvm/functions/Function2;)V", "byteOrder", "Lcom/ditchoom/buffer/ByteOrder;", "getByteOrder", "()Lcom/ditchoom/buffer/ByteOrder;", "getOrigin", "()Lcom/ditchoom/buffer/ReadBuffer;", "getTransformer", "()Lkotlin/jvm/functions/Function2;", "get", "index", "getInt", "getLong", "", "getShort", "", "limit", "position", "", "newPosition", "readByte", "readByteArray", "", "size", "readInt", "readLong", "readShort", "readString", "", "length", "charset", "Lcom/ditchoom/buffer/Charset;", "resetForRead", "setLimit", "slice", "buffer_release"})
public final class TransformedReadBuffer
implements ReadBuffer {
    @NotNull
    private final ReadBuffer origin;
    @NotNull
    private final Function2<Integer, Byte, Byte> transformer;
    @NotNull
    private final ByteOrder byteOrder;

    public TransformedReadBuffer(@NotNull ReadBuffer origin, @NotNull Function2<? super Integer, ? super Byte, Byte> transformer) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        this.origin = origin;
        this.transformer = transformer;
        this.byteOrder = this.origin.getByteOrder();
    }

    @NotNull
    public final ReadBuffer getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Function2<Integer, Byte, Byte> getTransformer() {
        return this.transformer;
    }

    @Override
    @NotNull
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public int limit() {
        return this.origin.limit();
    }

    @Override
    public void setLimit(int limit) {
        this.origin.setLimit(limit);
    }

    @Override
    public int position() {
        return this.origin.position();
    }

    @Override
    public void position(int newPosition) {
        this.origin.position(newPosition);
    }

    @Override
    public void resetForRead() {
        this.origin.resetForRead();
    }

    @Override
    public byte readByte() {
        return ((Number)this.transformer.invoke((Object)this.position(), (Object)this.origin.readByte())).byteValue();
    }

    @Override
    public byte get(int index) {
        return ((Number)this.transformer.invoke((Object)this.position(), (Object)this.origin.get(index))).byteValue();
    }

    @Override
    @NotNull
    public ReadBuffer slice() {
        return this.origin.slice();
    }

    @Override
    @NotNull
    public byte[] readByteArray(int size) {
        byte[] byteArray = this.origin.readByteArray(size);
        int n = byteArray.length;
        for (int position = 0; position < n; ++position) {
            byteArray[position] = ((Number)this.transformer.invoke((Object)position, (Object)byteArray[position])).byteValue();
        }
        return byteArray;
    }

    @Override
    public short readShort() {
        PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, 2, null, null, 6, null);
        buffer.writeShort(this.origin.readShort());
        buffer.resetForRead();
        byte byte1 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte2 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        buffer.resetForWrite();
        buffer.writeByte(byte1);
        buffer.writeByte(byte2);
        buffer.resetForRead();
        return buffer.readShort();
    }

    @Override
    public short getShort(int index) {
        PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, 2, null, null, 6, null);
        buffer.writeShort(this.origin.getShort(index));
        buffer.resetForRead();
        byte byte1 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte2 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        buffer.resetForWrite();
        buffer.writeByte(byte1);
        buffer.writeByte(byte2);
        buffer.resetForRead();
        return buffer.readShort();
    }

    @Override
    public int readInt() {
        PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, 4, null, null, 6, null);
        buffer.writeInt(this.origin.readInt());
        buffer.resetForRead();
        byte byte1 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte2 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte3 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte4 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        buffer.resetForWrite();
        buffer.writeByte(byte1);
        buffer.writeByte(byte2);
        buffer.writeByte(byte3);
        buffer.writeByte(byte4);
        buffer.resetForRead();
        return buffer.readInt();
    }

    @Override
    public int getInt(int index) {
        PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, 4, null, null, 6, null);
        buffer.writeInt(this.origin.getInt(index));
        buffer.resetForRead();
        byte byte1 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte2 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte3 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte4 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        buffer.resetForWrite();
        buffer.writeByte(byte1);
        buffer.writeByte(byte2);
        buffer.writeByte(byte3);
        buffer.writeByte(byte4);
        buffer.resetForRead();
        return buffer.readInt();
    }

    @Override
    public long readLong() {
        PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, 8, null, null, 6, null);
        buffer.writeLong(this.origin.readLong());
        buffer.resetForRead();
        byte byte1 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte2 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte3 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte4 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte5 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte6 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte7 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte8 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        buffer.resetForWrite();
        buffer.writeByte(byte1);
        buffer.writeByte(byte2);
        buffer.writeByte(byte3);
        buffer.writeByte(byte4);
        buffer.writeByte(byte5);
        buffer.writeByte(byte6);
        buffer.writeByte(byte7);
        buffer.writeByte(byte8);
        buffer.resetForRead();
        return buffer.readLong();
    }

    @Override
    public long getLong(int index) {
        PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, 8, null, null, 6, null);
        buffer.writeLong(this.origin.getLong(index));
        buffer.resetForRead();
        byte byte1 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte2 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte3 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte4 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte5 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte6 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte7 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        byte byte8 = ((Number)this.transformer.invoke((Object)this.position(), (Object)buffer.readByte())).byteValue();
        buffer.resetForWrite();
        buffer.writeByte(byte1);
        buffer.writeByte(byte2);
        buffer.writeByte(byte3);
        buffer.writeByte(byte4);
        buffer.writeByte(byte5);
        buffer.writeByte(byte6);
        buffer.writeByte(byte7);
        buffer.writeByte(byte8);
        buffer.resetForRead();
        return buffer.readLong();
    }

    @Override
    @NotNull
    public String readString(int length, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)((Object)charset), (String)"charset");
        if (WhenMappings.$EnumSwitchMapping$0[charset.ordinal()] != 1) {
            throw new UnsupportedOperationException("Unsupported charset " + (Object)((Object)charset));
        }
        return StringsKt.decodeToString((byte[])this.readByteArray(length));
    }

    @Override
    @NotNull
    public ReadBuffer readBytes(int size) {
        return ReadBuffer.DefaultImpls.readBytes(this, size);
    }

    @Override
    public byte readUnsignedByte-w2LRezQ() {
        return ReadBuffer.DefaultImpls.readUnsignedByte-w2LRezQ(this);
    }

    @Override
    public byte getUnsignedByte-Wa3L5BU(int index) {
        return ReadBuffer.DefaultImpls.getUnsignedByte-Wa3L5BU(this, index);
    }

    @Override
    public short readUnsignedShort-Mh2AYeg() {
        return ReadBuffer.DefaultImpls.readUnsignedShort-Mh2AYeg(this);
    }

    @Override
    public short getUnsignedShort-BwKQO78(int index) {
        return ReadBuffer.DefaultImpls.getUnsignedShort-BwKQO78(this, index);
    }

    @Override
    public int readUnsignedInt-pVg5ArA() {
        return ReadBuffer.DefaultImpls.readUnsignedInt-pVg5ArA(this);
    }

    @Override
    public int getUnsignedInt-OGnWXxg(int index) {
        return ReadBuffer.DefaultImpls.getUnsignedInt-OGnWXxg(this, index);
    }

    @Override
    public float readFloat() {
        return ReadBuffer.DefaultImpls.readFloat(this);
    }

    @Override
    public float getFloat(int index) {
        return ReadBuffer.DefaultImpls.getFloat(this, index);
    }

    @Override
    public long readUnsignedLong-s-VKNKU() {
        return ReadBuffer.DefaultImpls.readUnsignedLong-s-VKNKU(this);
    }

    @Override
    public long getUnsignedLong-I7RO_PI(int index) {
        return ReadBuffer.DefaultImpls.getUnsignedLong-I7RO_PI(this, index);
    }

    @Override
    public double readDouble() {
        return ReadBuffer.DefaultImpls.readDouble(this);
    }

    @Override
    public double getDouble(int index) {
        return ReadBuffer.DefaultImpls.getDouble(this, index);
    }

    @Override
    @Deprecated(message="Use readString instead", replaceWith=@ReplaceWith(expression="readString(bytes, Charset.UTF8)", imports={"com.ditchoom.buffer.Charset"}))
    @NotNull
    public CharSequence readUtf8-WZ4Q5Ns(int bytes) {
        return ReadBuffer.DefaultImpls.readUtf8-WZ4Q5Ns(this, bytes);
    }

    @Override
    @Deprecated(message="Use readString instead", replaceWith=@ReplaceWith(expression="readString(bytes, Charset.UTF8)", imports={"com.ditchoom.buffer.Charset"}))
    @NotNull
    public CharSequence readUtf8(int bytes) {
        return ReadBuffer.DefaultImpls.readUtf8(this, bytes);
    }

    @Override
    @NotNull
    public CharSequence readUtf8Line() {
        return ReadBuffer.DefaultImpls.readUtf8Line(this);
    }

    @Override
    public long readNumberWithByteSize(int numberOfBytes) {
        return ReadBuffer.DefaultImpls.readNumberWithByteSize(this, numberOfBytes);
    }

    @Override
    public long getNumberWithStartIndexAndByteSize(int startIndex, int numberOfBytes) {
        return ReadBuffer.DefaultImpls.getNumberWithStartIndexAndByteSize(this, startIndex, numberOfBytes);
    }

    @Override
    public int remaining() {
        return ReadBuffer.DefaultImpls.remaining(this);
    }

    @Override
    public boolean hasRemaining() {
        return ReadBuffer.DefaultImpls.hasRemaining(this);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Charset.values().length];
            try {
                nArray[Charset.UTF8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

