/*
 * Decompiled with CFR 0.152.
 */
package com.semanticversion;

import com.semanticversion.SemanticVersionConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B3\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u000205J\u0006\u00107\u001a\u000205J\u0010\u00108\u001a\u0002052\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u00109\u001a\u0002052\u0006\u0010*\u001a\u00020\bH\u0002J\b\u0010:\u001a\u00020\bH\u0016J\b\u0010;\u001a\u000205H\u0002R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR\u001a\u0010\u001f\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u001e\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b(\u0010\"\"\u0004\b)\u0010$R\u001c\u0010*\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0012\"\u0004\b,\u0010-R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b.\u0010\"\"\u0004\b/\u0010$R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b0\u0010\"\"\u0004\b1\u0010$R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b2\u0010\"\"\u0004\b3\u0010$\u00a8\u0006="}, d2={"Lcom/semanticversion/Version;", "", "versionMajor", "", "versionMinor", "versionPatch", "(III)V", "version", "", "maximumMajorVersion", "maximumMinorVersion", "maximumPatchVersion", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "baseVersion", "config", "Lcom/semanticversion/SemanticVersionConfig;", "(Ljava/lang/String;Lcom/semanticversion/SemanticVersionConfig;)V", "getBaseVersion", "()Ljava/lang/String;", "defaultMaximumVersion", "getDefaultMaximumVersion", "()I", "isAlpha", "", "()Z", "setAlpha", "(Z)V", "isBeta", "setBeta", "isRc", "setRc", "isSnapshot", "setSnapshot", "getMaximumMajorVersion", "()Ljava/lang/Integer;", "setMaximumMajorVersion", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getMaximumMinorVersion", "setMaximumMinorVersion", "getMaximumPatchVersion", "setMaximumPatchVersion", "versionClassifier", "getVersionClassifier", "setVersionClassifier", "(Ljava/lang/String;)V", "getVersionMajor", "setVersionMajor", "getVersionMinor", "setVersionMinor", "getVersionPatch", "setVersionPatch", "incrementMajor", "", "incrementMinor", "incrementPatch", "parseBaseVersion", "parseVersionClassifier", "toString", "validateBaseVersion", "Companion", "semantic-version"})
public class Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Integer versionMajor;
    @Nullable
    private Integer versionMinor;
    @Nullable
    private Integer versionPatch;
    @Nullable
    private String versionClassifier;
    private boolean isSnapshot;
    private boolean isAlpha;
    private boolean isBeta;
    private boolean isRc;
    @Nullable
    private Integer maximumMajorVersion;
    @Nullable
    private Integer maximumMinorVersion;
    @Nullable
    private Integer maximumPatchVersion;
    @NotNull
    public static final String VERSION_CLASSIFIER_SEPARATOR = "-";
    @NotNull
    public static final String SNAPSHOT_CLASSIFIER = "SNAPSHOT";
    @NotNull
    public static final String ALPHA_CLASSIFIER = "ALPHA";
    @NotNull
    public static final String BETA_CLASSIFIER = "BETA";
    @NotNull
    public static final String RC_CLASSIFIER = "RC";
    @NotNull
    public static final String BASE_VERSION_SEPARATOR = ".";

    @Nullable
    public final Integer getVersionMajor() {
        return this.versionMajor;
    }

    public final void setVersionMajor(@Nullable Integer n) {
        this.versionMajor = n;
    }

    @Nullable
    public final Integer getVersionMinor() {
        return this.versionMinor;
    }

    public final void setVersionMinor(@Nullable Integer n) {
        this.versionMinor = n;
    }

    @Nullable
    public final Integer getVersionPatch() {
        return this.versionPatch;
    }

    public final void setVersionPatch(@Nullable Integer n) {
        this.versionPatch = n;
    }

    @Nullable
    public final String getVersionClassifier() {
        return this.versionClassifier;
    }

    public final void setVersionClassifier(@Nullable String string) {
        this.versionClassifier = string;
    }

    public final boolean isSnapshot() {
        return this.isSnapshot;
    }

    public final void setSnapshot(boolean bl) {
        this.isSnapshot = bl;
    }

    public final boolean isAlpha() {
        return this.isAlpha;
    }

    public final void setAlpha(boolean bl) {
        this.isAlpha = bl;
    }

    public final boolean isBeta() {
        return this.isBeta;
    }

    public final void setBeta(boolean bl) {
        this.isBeta = bl;
    }

    public final boolean isRc() {
        return this.isRc;
    }

    public final void setRc(boolean bl) {
        this.isRc = bl;
    }

    @Nullable
    public final Integer getMaximumMajorVersion() {
        return this.maximumMajorVersion;
    }

    public final void setMaximumMajorVersion(@Nullable Integer n) {
        this.maximumMajorVersion = n;
    }

    @Nullable
    public final Integer getMaximumMinorVersion() {
        return this.maximumMinorVersion;
    }

    public final void setMaximumMinorVersion(@Nullable Integer n) {
        this.maximumMinorVersion = n;
    }

    @Nullable
    public final Integer getMaximumPatchVersion() {
        return this.maximumPatchVersion;
    }

    public final void setMaximumPatchVersion(@Nullable Integer n) {
        this.maximumPatchVersion = n;
    }

    protected int getDefaultMaximumVersion() {
        return 99;
    }

    @NotNull
    public final String getBaseVersion() {
        return "" + this.versionMajor + '.' + this.versionMinor + '.' + this.versionPatch;
    }

    public Version(int versionMajor, int versionMinor, int versionPatch) {
        this.isSnapshot = true;
        this.maximumMajorVersion = this.getDefaultMaximumVersion();
        this.maximumMinorVersion = this.getDefaultMaximumVersion();
        this.maximumPatchVersion = this.getDefaultMaximumVersion();
        this.versionMajor = versionMajor;
        this.versionMinor = versionMinor;
        this.versionPatch = versionPatch;
        this.validateBaseVersion();
    }

    public Version(@NotNull String version, @Nullable Integer maximumMajorVersion, @Nullable Integer maximumMinorVersion, @Nullable Integer maximumPatchVersion) {
        Integer n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.isSnapshot = true;
        Integer n3 = maximumMajorVersion;
        if (n3 == null) {
            n3 = this.maximumMajorVersion = Integer.valueOf(this.getDefaultMaximumVersion());
        }
        if ((n2 = maximumMinorVersion) == null) {
            n2 = this.maximumMinorVersion = Integer.valueOf(this.getDefaultMaximumVersion());
        }
        if ((n = maximumPatchVersion) == null) {
            n = this.getDefaultMaximumVersion();
        }
        this.maximumPatchVersion = n;
        String[] stringArray = new String[]{VERSION_CLASSIFIER_SEPARATOR};
        List split = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String baseVersion = (String)split.get(0);
        this.parseBaseVersion(baseVersion);
        if (split.size() > 1) {
            String string = this.versionClassifier = (String)split.get(1);
            Intrinsics.checkNotNull((Object)string);
            this.parseVersionClassifier(string);
        } else {
            this.isSnapshot = false;
            this.isAlpha = false;
            this.isBeta = false;
        }
    }

    public /* synthetic */ Version(String string, Integer n, Integer n2, Integer n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = null;
        }
        if ((n4 & 4) != 0) {
            n2 = null;
        }
        if ((n4 & 8) != 0) {
            n3 = null;
        }
        this(string, n, n2, n3);
    }

    public Version(@NotNull String baseVersion, @NotNull SemanticVersionConfig config) {
        Integer n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)baseVersion, (String)"baseVersion");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.isSnapshot = true;
        Integer n3 = config.getMaximumMajorVersion();
        if (n3 == null) {
            n3 = this.maximumMajorVersion = Integer.valueOf(this.getDefaultMaximumVersion());
        }
        if ((n2 = config.getMaximumMinorVersion()) == null) {
            n2 = this.maximumMinorVersion = Integer.valueOf(this.getDefaultMaximumVersion());
        }
        if ((n = config.getMaximumPatchVersion()) == null) {
            n = this.getDefaultMaximumVersion();
        }
        this.maximumPatchVersion = n;
        this.parseBaseVersion(baseVersion);
        this.versionClassifier = config.getVersionClassifier();
        if (this.versionClassifier == null) {
            if (Intrinsics.areEqual((Object)config.getSnapshot(), (Object)true) || config.getSnapshot() == null) {
                this.versionClassifier = SNAPSHOT_CLASSIFIER;
                this.isSnapshot = true;
                this.isAlpha = false;
                this.isBeta = false;
                this.isRc = false;
            } else {
                this.isSnapshot = false;
                this.isAlpha = false;
                this.isBeta = false;
                this.isRc = false;
            }
            if (Intrinsics.areEqual((Object)config.getAlpha(), (Object)true)) {
                this.versionClassifier = ALPHA_CLASSIFIER;
                this.isSnapshot = false;
                this.isAlpha = true;
                this.isBeta = false;
                this.isRc = false;
            }
            if (Intrinsics.areEqual((Object)config.getBeta(), (Object)true)) {
                this.versionClassifier = BETA_CLASSIFIER;
                this.isSnapshot = false;
                this.isAlpha = false;
                this.isBeta = true;
                this.isRc = false;
            }
            if (Intrinsics.areEqual((Object)config.getRc(), (Object)true)) {
                this.versionClassifier = RC_CLASSIFIER;
                this.isSnapshot = false;
                this.isAlpha = false;
                this.isBeta = false;
                this.isRc = true;
            }
        } else {
            String string = this.versionClassifier;
            Intrinsics.checkNotNull((Object)string);
            this.parseVersionClassifier(string);
        }
    }

    private final void parseVersionClassifier(String versionClassifier) {
        switch (versionClassifier) {
            case "SNAPSHOT": {
                this.isSnapshot = true;
                this.isBeta = false;
                this.isAlpha = false;
                this.isRc = false;
                break;
            }
            case "ALPHA": {
                this.isSnapshot = false;
                this.isBeta = false;
                this.isAlpha = true;
                this.isRc = false;
                break;
            }
            case "BETA": {
                this.isSnapshot = false;
                this.isBeta = true;
                this.isAlpha = false;
                this.isRc = false;
                break;
            }
            case "RC": {
                this.isSnapshot = false;
                this.isBeta = false;
                this.isAlpha = false;
                this.isRc = true;
                break;
            }
            default: {
                this.isSnapshot = false;
                this.isBeta = false;
                this.isAlpha = false;
                this.isRc = false;
            }
        }
    }

    private final void parseBaseVersion(String baseVersion) {
        String[] stringArray = new String[]{BASE_VERSION_SEPARATOR};
        List versionSplit = StringsKt.split$default((CharSequence)baseVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (versionSplit.size() != 3) {
            throw new RuntimeException("The version [" + baseVersion + "] is not a valid Semantic Versioning");
        }
        this.versionMajor = Integer.parseInt((String)versionSplit.get(0));
        this.versionMinor = Integer.parseInt((String)versionSplit.get(1));
        this.versionPatch = Integer.parseInt((String)versionSplit.get(2));
        this.validateBaseVersion();
    }

    private final void validateBaseVersion() {
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                Integer n = this.versionMajor;
                                Intrinsics.checkNotNull((Object)n);
                                int n2 = n;
                                Integer n3 = this.maximumMajorVersion;
                                Intrinsics.checkNotNull((Object)n3);
                                if (n2 > n3) break block6;
                                Integer n4 = this.versionMajor;
                                Intrinsics.checkNotNull((Object)n4);
                                if (n4 >= 0) break block7;
                            }
                            throw new RuntimeException("The version major [" + this.versionMajor + "] should be a number between 0 and " + this.maximumMajorVersion);
                        }
                        Integer n = this.versionMinor;
                        Intrinsics.checkNotNull((Object)n);
                        int n5 = n;
                        Integer n6 = this.maximumMinorVersion;
                        Intrinsics.checkNotNull((Object)n6);
                        if (n5 > n6) break block8;
                        Integer n7 = this.versionMinor;
                        Intrinsics.checkNotNull((Object)n7);
                        if (n7 >= 0) break block9;
                    }
                    throw new RuntimeException("The version minor [" + this.versionMinor + "] should be a number between 0 and " + this.maximumMinorVersion);
                }
                Integer n = this.versionPatch;
                Intrinsics.checkNotNull((Object)n);
                int n8 = n;
                Integer n9 = this.maximumPatchVersion;
                Intrinsics.checkNotNull((Object)n9);
                if (n8 > n9) break block10;
                Integer n10 = this.versionPatch;
                Intrinsics.checkNotNull((Object)n10);
                if (n10 >= 0) break block11;
            }
            throw new RuntimeException("The version patch [" + this.versionPatch + "] should be a number between 0 and " + this.maximumPatchVersion);
        }
    }

    public final void incrementMajor() {
        Integer n = this.versionMajor;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = this.maximumMajorVersion;
        Intrinsics.checkNotNull((Object)n3);
        if (n2 >= n3) {
            throw new RuntimeException("The version major [" + this.versionMajor + "] can't be incremented. Maximum value achieved.");
        }
        Integer n4 = this.versionMajor;
        Intrinsics.checkNotNull((Object)n4);
        this.versionMajor = n4 + 1;
        this.versionMinor = 0;
        this.versionPatch = 0;
    }

    public final void incrementMinor() {
        Integer n = this.versionMinor;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = this.maximumMinorVersion;
        Intrinsics.checkNotNull((Object)n3);
        if (n2 < n3) {
            Integer n4 = this.versionMinor;
            Intrinsics.checkNotNull((Object)n4);
            this.versionMinor = n4 + 1;
            this.versionPatch = 0;
        } else {
            this.incrementMajor();
        }
    }

    public final void incrementPatch() {
        Integer n = this.versionPatch;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = this.maximumPatchVersion;
        Intrinsics.checkNotNull((Object)n3);
        if (n2 < n3) {
            Integer n4 = this.versionPatch;
            Intrinsics.checkNotNull((Object)n4);
            this.versionPatch = n4 + 1;
        } else {
            this.incrementMinor();
        }
    }

    @NotNull
    public String toString() {
        String versionName = this.getBaseVersion();
        CharSequence charSequence = this.versionClassifier;
        if (!(charSequence == null || charSequence.length() == 0)) {
            versionName = versionName + '-' + this.versionClassifier;
        }
        return versionName;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/semanticversion/Version$Companion;", "", "()V", "ALPHA_CLASSIFIER", "", "BASE_VERSION_SEPARATOR", "BETA_CLASSIFIER", "RC_CLASSIFIER", "SNAPSHOT_CLASSIFIER", "VERSION_CLASSIFIER_SEPARATOR", "semantic-version"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

