/*
 * Decompiled with CFR 0.152.
 */
package com.dinuscxj.refresh;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import com.dinuscxj.recyclerrefreshlayout.R;
import com.dinuscxj.refresh.IRefreshStatus;

public class RefreshView
extends ImageView
implements IRefreshStatus {
    private static final int ANIMATION_DURATION = 150;
    private static final Interpolator ANIMATION_INTERPOLATOR = new DecelerateInterpolator();
    private Animation mRotateAnimation;
    private Animation mResetRotateAnimation;

    public RefreshView(Context context) {
        this(context, null);
    }

    public RefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
        this.initAnimation();
    }

    private void initView() {
        this.setScaleType(ImageView.ScaleType.CENTER);
        this.setImageResource(R.drawable.default_ptr_flip);
    }

    private void initAnimation() {
        this.mRotateAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateAnimation.setInterpolator(ANIMATION_INTERPOLATOR);
        this.mRotateAnimation.setDuration(150L);
        this.mRotateAnimation.setFillAfter(true);
        this.mResetRotateAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mResetRotateAnimation.setInterpolator(ANIMATION_INTERPOLATOR);
        this.mResetRotateAnimation.setDuration(150L);
        this.mResetRotateAnimation.setFillAfter(true);
    }

    @Override
    public void reset() {
        this.clearAnimation();
        this.setImageDrawable(this.getResources().getDrawable(R.drawable.default_ptr_flip));
    }

    @Override
    public void refreshing() {
        this.clearAnimation();
        AnimationDrawable drawable2 = (AnimationDrawable)this.getResources().getDrawable(R.drawable.spinner);
        drawable2.start();
        this.setImageDrawable((Drawable)drawable2);
    }

    @Override
    public void pullToRefresh() {
        this.clearAnimation();
        if (this.getAnimation() == null || this.getAnimation() == this.mResetRotateAnimation) {
            this.startAnimation(this.mRotateAnimation);
        }
    }

    @Override
    public void releaseToRefresh() {
        this.clearAnimation();
        if (this.mRotateAnimation == this.getAnimation()) {
            this.startAnimation(this.mResetRotateAnimation);
        }
    }

    @Override
    public void pullProgress(float pullDistance, float pullProgress) {
    }
}

