/*
 * Decompiled with CFR 0.152.
 */
package com.dinuscxj.pullzoom;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.dinuscxj.pullzoom.PullZoomBaseView;

public class PullZoomRecyclerView
extends PullZoomBaseView<RecyclerView> {
    private int mHeaderContainerHeight;
    private int mZoomViewHeight;
    private Interpolator sSmoothToTopInterpolator;
    private ZoomBackRunnable mZoomBackAnimation;

    public PullZoomRecyclerView(Context context) {
        this(context, null);
    }

    public PullZoomRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mHeaderContainerHeight = 0;
        this.mZoomViewHeight = 0;
        this.sSmoothToTopInterpolator = this.createDefaultInterpolator();
        this.mZoomBackAnimation = new ZoomBackRunnable();
    }

    private Interpolator createDefaultInterpolator() {
        return new DecelerateInterpolator(2.0f);
    }

    @Override
    protected RecyclerView createWrapperView(Context context, AttributeSet attrs) {
        RecyclerView recyclerView = new RecyclerView(context, attrs);
        recyclerView.setId(Integer.MIN_VALUE);
        return recyclerView;
    }

    @Override
    protected int createDefaultPullZoomModel() {
        return 0;
    }

    @Override
    protected boolean isReadyZoom() {
        if (this.mMode == 0) {
            return this.isFirstItemCompletelyVisible();
        }
        if (this.mMode == 1) {
            return this.isLastItemCompletelyVisible();
        }
        return false;
    }

    @Override
    protected void pullZoomEvent(float scrollValue) {
        if (this.mZoomBackAnimation != null && !this.mZoomBackAnimation.isFinished()) {
            this.mZoomBackAnimation.abortAnimation();
        }
        if (this.mHeaderContainer != null) {
            ViewGroup.LayoutParams layoutParams = this.mHeaderContainer.getLayoutParams();
            layoutParams.height = (int)(Math.abs(scrollValue) + (float)this.mHeaderContainerHeight);
            this.mHeaderContainer.setLayoutParams(layoutParams);
            ViewGroup.LayoutParams zoomViewLayoutParams = this.mZoomView.getLayoutParams();
            zoomViewLayoutParams.height = this.mZoomViewHeight + layoutParams.height - this.mHeaderContainerHeight;
            this.mZoomView.setLayoutParams(zoomViewLayoutParams);
        }
        if (this.mMode == 1) {
            ((RecyclerView)this.mWrapperView).scrollToPosition(((RecyclerView)this.mWrapperView).getAdapter().getItemCount() - 1);
        }
    }

    @Override
    protected void smoothScrollToTop() {
        this.mZoomBackAnimation.startAnimation(300L);
    }

    public RecyclerView getRecyclerView() {
        return (RecyclerView)this.mWrapperView;
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        ((RecyclerView)this.mWrapperView).setAdapter(adapter);
    }

    public void setLayoutManager(RecyclerView.LayoutManager manager) {
        ((RecyclerView)this.mWrapperView).setLayoutManager(manager);
    }

    public void setSmoothToTopInterpolator(Interpolator sSmoothToTopInterpolator) {
        this.sSmoothToTopInterpolator = sSmoothToTopInterpolator;
    }

    private boolean isFirstItemCompletelyVisible() {
        if (this.mWrapperView != null) {
            RecyclerView.Adapter adapter = ((RecyclerView)this.mWrapperView).getAdapter();
            RecyclerView.LayoutManager mLayoutManager = ((RecyclerView)this.mWrapperView).getLayoutManager();
            if (null == adapter || adapter.getItemCount() == 0) {
                return false;
            }
            if (null == mLayoutManager || mLayoutManager.getItemCount() == 0) {
                return false;
            }
            return this.checkFirstItemCompletelyVisible(mLayoutManager);
        }
        return false;
    }

    private boolean checkFirstItemCompletelyVisible(RecyclerView.LayoutManager mLayoutManager) {
        View firstVisibleChild;
        int firstVisiblePosition = ((RecyclerView.LayoutParams)mLayoutManager.getChildAt(0).getLayoutParams()).getViewPosition();
        if (firstVisiblePosition == 0 && (firstVisibleChild = ((RecyclerView)this.mWrapperView).getChildAt(0)) != null) {
            return firstVisibleChild.getTop() >= ((RecyclerView)this.mWrapperView).getTop();
        }
        return false;
    }

    private boolean isLastItemCompletelyVisible() {
        if (this.mWrapperView != null) {
            RecyclerView.Adapter adapter = ((RecyclerView)this.mWrapperView).getAdapter();
            RecyclerView.LayoutManager mLayoutmanager = ((RecyclerView)this.mWrapperView).getLayoutManager();
            if (null == adapter || adapter.getItemCount() == 0) {
                return true;
            }
            if (null == mLayoutmanager || mLayoutmanager.getItemCount() == 0) {
                return false;
            }
            return this.checkLastItemCompletelyVisible(mLayoutmanager);
        }
        return false;
    }

    private boolean checkLastItemCompletelyVisible(RecyclerView.LayoutManager mLayoutmanager) {
        View lastVisibleChild;
        int lastVisiblePosition = mLayoutmanager.getChildCount() - 1;
        int currentLastVisiblePosition = ((RecyclerView.LayoutParams)mLayoutmanager.getChildAt(lastVisiblePosition).getLayoutParams()).getViewPosition();
        if (currentLastVisiblePosition == mLayoutmanager.getItemCount() - 1 && (lastVisibleChild = ((RecyclerView)this.mWrapperView).getChildAt(lastVisiblePosition)) != null) {
            if (this.mHeaderContainer != null && this.mHeaderContainerHeight <= 0) {
                this.mHeaderContainerHeight = this.mHeaderContainer.getMeasuredHeight();
            }
            return lastVisibleChild.getBottom() <= ((RecyclerView)this.mWrapperView).getBottom();
        }
        return false;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mHeaderContainer != null && this.mHeaderContainerHeight <= 0) {
            this.mHeaderContainerHeight = this.mHeaderContainer.getMeasuredHeight();
        }
        if (this.mZoomView != null && this.mZoomViewHeight <= 0) {
            this.mZoomViewHeight = this.mZoomView.getMeasuredHeight();
        }
    }

    private class ZoomBackRunnable
    implements Runnable {
        protected long mDuration;
        protected boolean mIsFinished = true;
        protected float mScale;
        protected long mStartTime;

        ZoomBackRunnable() {
        }

        public void abortAnimation() {
            this.mIsFinished = true;
        }

        public boolean isFinished() {
            return this.mIsFinished;
        }

        @Override
        public void run() {
            if (PullZoomRecyclerView.this.mZoomView != null && !this.mIsFinished && this.mScale > 1.0f) {
                float zoomBackProgress = (float)(System.currentTimeMillis() - this.mStartTime) / (float)this.mDuration;
                ViewGroup.LayoutParams headerContainerLayoutParams = PullZoomRecyclerView.this.mHeaderContainer.getLayoutParams();
                ViewGroup.LayoutParams zoomViewLayoutParams = PullZoomRecyclerView.this.mZoomView.getLayoutParams();
                if (zoomBackProgress > 1.0f) {
                    headerContainerLayoutParams.height = PullZoomRecyclerView.this.mHeaderContainerHeight;
                    PullZoomRecyclerView.this.mHeaderContainer.setLayoutParams(headerContainerLayoutParams);
                    zoomViewLayoutParams.height = PullZoomRecyclerView.this.mZoomViewHeight;
                    PullZoomRecyclerView.this.mZoomView.setLayoutParams(zoomViewLayoutParams);
                    this.mIsFinished = true;
                    return;
                }
                float currentScale = this.mScale - (this.mScale - 1.0f) * PullZoomRecyclerView.this.sSmoothToTopInterpolator.getInterpolation(zoomBackProgress);
                headerContainerLayoutParams.height = (int)(currentScale * (float)PullZoomRecyclerView.this.mHeaderContainerHeight);
                PullZoomRecyclerView.this.mHeaderContainer.setLayoutParams(headerContainerLayoutParams);
                zoomViewLayoutParams.height = PullZoomRecyclerView.this.mZoomViewHeight + headerContainerLayoutParams.height - PullZoomRecyclerView.this.mHeaderContainerHeight;
                PullZoomRecyclerView.this.mZoomView.setLayoutParams(zoomViewLayoutParams);
                PullZoomRecyclerView.this.post(this);
            }
        }

        public void startAnimation(long animationDuration) {
            if (PullZoomRecyclerView.this.mZoomView != null) {
                this.mStartTime = System.currentTimeMillis();
                this.mDuration = animationDuration;
                this.mScale = (float)PullZoomRecyclerView.this.mHeaderContainer.getHeight() / (float)PullZoomRecyclerView.this.mHeaderContainerHeight;
                this.mIsFinished = false;
                PullZoomRecyclerView.this.post(this);
            }
        }
    }
}

