/*
 * Decompiled with CFR 0.152.
 */
package com.dinuscxj.pullzoom;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public abstract class PullZoomBaseView<T extends View>
extends LinearLayout {
    protected static final long ZOOM_BACK_DURATION = 300L;
    private static final float FRICTION = 2.5f;
    public static final int ZOOM_HEADER = 0;
    public static final int ZOOM_FOOTER = 1;
    protected T mWrapperView;
    protected ViewGroup mHeaderContainer;
    protected View mZoomView;
    private float mInitTouchY;
    private float mInitTouchX;
    private float mLastTouchX;
    private float mLastTouchY;
    private boolean isZoomEnable;
    private boolean isZooming;
    private boolean isPullStart;
    protected int mMode;
    private int mTouchSlop;
    private OnPullZoomListener mOnPullZoomListener;

    public PullZoomBaseView(Context context) {
        this(context, null);
    }

    public PullZoomBaseView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMode = this.createDefaultPullZoomModel();
        this.isZoomEnable = true;
        this.isPullStart = false;
        this.isZooming = false;
        this.mWrapperView = this.createWrapperView(context, attrs);
        this.addView((View)this.mWrapperView, -1, -1);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isZoomEnable) {
            return false;
        }
        if (event.getEdgeFlags() != 0 && event.getAction() == 0) {
            return false;
        }
        return this.performTouchAction(event);
    }

    private boolean performTouchAction(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                if (!this.isPullStart) break;
                return this.onPullStartActionMove(event);
            }
            case 1: 
            case 3: {
                if (!this.isPullStart) break;
                return this.onPullStartActionCancel();
            }
        }
        return false;
    }

    private boolean onPullStartActionMove(MotionEvent event) {
        this.isZooming = true;
        this.mLastTouchY = event.getY();
        this.mLastTouchX = event.getX();
        float scrollValue = this.mMode == 0 ? (float)Math.round(Math.min(this.mInitTouchY - this.mLastTouchY, 0.0f) / 2.5f) : (float)Math.round(Math.max(this.mInitTouchY - this.mLastTouchY, 0.0f) / 2.5f);
        this.pullZoomEvent(scrollValue);
        if (this.mOnPullZoomListener != null) {
            this.mOnPullZoomListener.onPullZooming(scrollValue);
        }
        return true;
    }

    private boolean onPullStartActionCancel() {
        this.isPullStart = false;
        if (this.isZooming) {
            this.isZooming = false;
            this.smoothScrollToTop();
            if (this.mOnPullZoomListener != null) {
                float scrollValue = this.mMode == 0 ? (float)Math.round(Math.min(this.mInitTouchY - this.mLastTouchY, 0.0f) / 2.5f) : (float)Math.round(Math.max(this.mInitTouchY - this.mLastTouchY, 0.0f) / 2.5f);
                this.mOnPullZoomListener.onPullZoomEnd(scrollValue);
            }
        }
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isZoomEnable) {
            return false;
        }
        if (event.getAction() == 2 && this.isPullStart) {
            return true;
        }
        this.performInterceptAction(event);
        return this.isPullStart;
    }

    private void performInterceptAction(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (!this.isReadyZoom()) break;
                this.onZoomReadyActionDown(event);
                break;
            }
            case 2: {
                if (!this.isReadyZoom()) break;
                this.onZoomReadyActionMove(event);
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
    }

    private void onZoomReadyActionDown(MotionEvent event) {
        this.mInitTouchY = this.mLastTouchY = event.getY();
        this.mInitTouchX = this.mLastTouchX = event.getX();
        this.isPullStart = false;
    }

    private void onZoomReadyActionMove(MotionEvent event) {
        float mCurrentX = event.getX();
        float mCurrentY = event.getY();
        float xDistance = mCurrentX - this.mLastTouchX;
        float yDistance = mCurrentY - this.mLastTouchY;
        Log.i((String)"debug", (String)("mMode" + this.mMode + "yDistance " + yDistance + "xDistance " + xDistance));
        if (this.mMode == 0 && yDistance > (float)this.mTouchSlop && yDistance > Math.abs(xDistance) || this.mMode == 1 && -yDistance > (float)this.mTouchSlop && -yDistance > Math.abs(xDistance)) {
            this.mLastTouchY = mCurrentY;
            this.mLastTouchX = mCurrentX;
            if (this.mOnPullZoomListener != null) {
                this.mOnPullZoomListener.onPullStart();
            }
            this.isPullStart = true;
        }
    }

    public void setModel(int mModel) {
        this.mMode = mModel;
    }

    public void setOnPullZoomListener(OnPullZoomListener mOnPullZoomListener) {
        this.mOnPullZoomListener = mOnPullZoomListener;
    }

    public void setIsZoomEnable(boolean isZoomEnable) {
        this.isZoomEnable = isZoomEnable;
    }

    public void setZoomView(View mZoomView) {
        this.mZoomView = mZoomView;
    }

    public void setHeaderContainer(ViewGroup mHeaderContainer) {
        this.mHeaderContainer = mHeaderContainer;
    }

    public boolean isZoomEnable() {
        return this.isZoomEnable;
    }

    public boolean isZooming() {
        return this.isZooming;
    }

    protected abstract T createWrapperView(Context var1, AttributeSet var2);

    protected abstract int createDefaultPullZoomModel();

    protected abstract boolean isReadyZoom();

    protected abstract void pullZoomEvent(float var1);

    protected abstract void smoothScrollToTop();

    public static interface OnPullZoomListener {
        public void onPullZooming(float var1);

        public void onPullStart();

        public void onPullZoomEnd(float var1);
    }
}

