/*
 * Decompiled with CFR 0.152.
 */
package com.dinuscxj.pullzoom;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public abstract class PullZoomBaseView<T extends View>
extends LinearLayout {
    protected static final long ZOOM_BACK_DURATION = 300L;
    private static final float FRICTION = 2.5f;
    public static final int ZOOM_HEADER = 0;
    public static final int ZOOM_FOOTER = 1;
    protected T mWrapperView;
    protected ViewGroup mHeaderContainer;
    protected View mZoomView;
    private float mInitTouchX;
    private float mInitTouchY;
    private float mLastTouchX;
    private float mLastTouchY;
    private boolean isZoomEnable;
    private boolean isZooming;
    private boolean isPullStart;
    protected int mModel;
    private int mTouchSlop;
    private OnPullZoomListener mOnPullZoomListener;

    public PullZoomBaseView(Context context) {
        this(context, null);
    }

    public PullZoomBaseView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mModel = this.createDefaultPullZoomModel();
        this.isZoomEnable = true;
        this.isPullStart = false;
        this.isZooming = false;
        this.mWrapperView = this.createWrapperView(context, attrs);
        this.addView((View)this.mWrapperView, -1, -1);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isZoomEnable) {
            return false;
        }
        if (event.getEdgeFlags() != 0 && event.getAction() == 0) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                if (!this.isPullStart) break;
                this.isZooming = true;
                this.mLastTouchY = event.getY();
                this.mLastTouchX = event.getX();
                float scrollValue = this.mModel == 0 ? (float)Math.round(Math.min(this.mInitTouchY - this.mLastTouchY, 0.0f) / 2.5f) : (float)Math.round(Math.max(this.mInitTouchY - this.mLastTouchY, 0.0f) / 2.5f);
                this.pullZoomEvent(scrollValue);
                if (this.mOnPullZoomListener != null) {
                    this.mOnPullZoomListener.onPullZooming(scrollValue);
                }
                return true;
            }
            case 1: 
            case 3: {
                if (!this.isPullStart) break;
                this.isPullStart = false;
                if (this.isZooming) {
                    this.isZooming = false;
                    this.smoothScrollToTop();
                    if (this.mOnPullZoomListener != null) {
                        float scrollValue = this.mModel == 0 ? (float)Math.round(Math.min(this.mInitTouchY - this.mLastTouchY, 0.0f) / 2.5f) : (float)Math.round(Math.max(this.mInitTouchY - this.mLastTouchY, 0.0f) / 2.5f);
                        this.mOnPullZoomListener.onPullZoomEnd(scrollValue);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isZoomEnable) {
            return false;
        }
        if (event.getAction() == 2 && this.isPullStart) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                if (!this.isReadyZoom()) break;
                this.mInitTouchX = this.mLastTouchX = event.getX();
                this.mInitTouchY = this.mLastTouchY = event.getY();
                this.isPullStart = false;
                break;
            }
            case 2: {
                if (!this.isReadyZoom()) break;
                float mCurrentX = event.getX();
                float mCurrentY = event.getY();
                float xDistance = mCurrentX - this.mLastTouchX;
                float yDistance = mCurrentY - this.mLastTouchY;
                if (!(this.mModel == 0 && yDistance > (float)this.mTouchSlop && yDistance > Math.abs(xDistance)) && (this.mModel != 1 || !(-yDistance > (float)this.mTouchSlop) || !(-yDistance > Math.abs(xDistance)))) break;
                this.mLastTouchY = mCurrentY;
                this.mLastTouchX = mCurrentX;
                if (this.mOnPullZoomListener != null) {
                    this.mOnPullZoomListener.onPullStart();
                }
                this.isPullStart = true;
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
        return this.isPullStart;
    }

    public void setModel(int mModel) {
        this.mModel = mModel;
    }

    public void setOnPullZoomListener(OnPullZoomListener mOnPullZoomListener) {
        this.mOnPullZoomListener = mOnPullZoomListener;
    }

    public void setIsZoomEnable(boolean isZoomEnable) {
        this.isZoomEnable = isZoomEnable;
    }

    public void setZoomView(View mZoomView) {
        this.mZoomView = mZoomView;
    }

    public void setHeaderContainer(ViewGroup mHeaderContainer) {
        this.mHeaderContainer = mHeaderContainer;
    }

    public boolean isZoomEnable() {
        return this.isZoomEnable;
    }

    public boolean isZooming() {
        return this.isZooming;
    }

    protected abstract T createWrapperView(Context var1, AttributeSet var2);

    protected abstract int createDefaultPullZoomModel();

    protected abstract boolean isReadyZoom();

    protected abstract void pullZoomEvent(float var1);

    protected abstract void smoothScrollToTop();

    public static interface OnPullZoomListener {
        public void onPullZooming(float var1);

        public void onPullStart();

        public void onPullZoomEnd(float var1);
    }
}

