/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.api.open;

import com.dingtalk.open.app.api.DingTalkAppError;
import com.dingtalk.open.app.api.open.OpenApiClient;
import com.dingtalk.open.app.api.open.OpenConnectionRequest;
import com.dingtalk.open.app.api.open.OpenConnectionResponse;
import com.dingtalk.open.app.api.util.IoUtils;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import shade.com.alibaba.fastjson2.JSON;
import shade.com.alibaba.fastjson2.JSONWriter;

class HttpOpenApiClient
implements OpenApiClient {
    private final String host;
    private final Proxy proxy;
    private final int timeout;

    public HttpOpenApiClient(String host, int timeout, Proxy proxy) {
        this.host = host;
        this.timeout = timeout;
        this.proxy = proxy;
    }

    @Override
    public OpenConnectionResponse openConnection(OpenConnectionRequest request) throws Exception {
        URL url = new URL(this.host + "/v1.0/gateway/connections/open");
        HttpURLConnection connection = this.proxy != null ? (HttpURLConnection)url.openConnection(this.proxy) : (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setReadTimeout(this.timeout);
        connection.setConnectTimeout(this.timeout);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.connect();
        connection.getOutputStream().write(JSON.toJSONBytes((Object)request, JSONWriter.Feature.WriteEnumUsingToString));
        connection.getOutputStream().flush();
        if (connection.getResponseCode() == 200) {
            byte[] content = IoUtils.readAll(connection.getInputStream());
            return JSON.parseObject(content, OpenConnectionResponse.class);
        }
        byte[] content = IoUtils.readAll(connection.getErrorStream());
        throw DingTalkAppError.HTTP_ERROR_RESPONSE.toException(String.format("status=%s,msg=%s", connection.getResponseCode(), content != null ? new String(content) : ""));
    }
}

