/*
 * Decompiled with CFR 0.152.
 */
package com.dilusense.customkeyboard;

import android.app.Activity;
import android.content.Context;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.Build;
import android.text.Editable;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.dilusense.customkeyboard.KeyModel;
import com.dilusense.customkeyboard.MyKeyBoardView;
import com.dilusense.customkeyboard.R;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class BaseKeyboard {
    private Activity mActivity;
    MyKeyBoardView mKeyboardView;
    Keyboard Keyboard;
    EditText mEditText;
    int layoutResId;
    boolean mIfRandom;
    public boolean isAttached;
    private KeyboardView.OnKeyboardActionListener mOnKeyboardActionListener = new KeyboardView.OnKeyboardActionListener(){

        public void onPress(int primaryCode) {
        }

        public void onRelease(int primaryCode) {
        }

        public void onKey(int primaryCode, int[] keyCodes) {
            Editable editable = BaseKeyboard.this.mEditText.getText();
            int start = BaseKeyboard.this.mEditText.getSelectionStart();
            Keyboard cfr_ignored_0 = BaseKeyboard.this.Keyboard;
            if (primaryCode == -5) {
                if (editable != null && editable.length() > 0 && start > 0) {
                    editable.delete(start - 1, start);
                }
            } else {
                Keyboard cfr_ignored_1 = BaseKeyboard.this.Keyboard;
                if (primaryCode == -3) {
                    BaseKeyboard.this.hideKeyboard();
                    if (BaseKeyboard.this.mOnCancelClick != null) {
                        BaseKeyboard.this.mOnCancelClick.onCancellClick();
                    }
                } else {
                    Keyboard cfr_ignored_2 = BaseKeyboard.this.Keyboard;
                    if (primaryCode == -4) {
                        BaseKeyboard.this.hideKeyboard();
                        if (BaseKeyboard.this.mOnOkClick != null) {
                            BaseKeyboard.this.mOnOkClick.onOkClick();
                        }
                    } else {
                        editable.insert(start, (CharSequence)Character.toString((char)primaryCode));
                    }
                }
            }
        }

        public void onText(CharSequence text) {
        }

        public void swipeLeft() {
        }

        public void swipeRight() {
        }

        public void swipeDown() {
        }

        public void swipeUp() {
        }
    };
    public OnOkClick mOnOkClick = null;
    public onCancelClick mOnCancelClick;

    public void init(Activity activity, int layoutResId) {
        this.mActivity = activity;
        this.layoutResId = layoutResId;
        this.isAttached = false;
        this.Keyboard = new Keyboard((Context)this.mActivity, layoutResId);
        this.mKeyboardView = (MyKeyBoardView)this.mActivity.findViewById(R.id.keyboard_view);
    }

    public void init(Activity activity, int layoutResId, boolean mIfRandom) {
        this.mActivity = activity;
        this.layoutResId = layoutResId;
        this.mIfRandom = mIfRandom;
        this.Keyboard = new Keyboard((Context)this.mActivity, layoutResId);
        this.mKeyboardView = (MyKeyBoardView)this.mActivity.findViewById(R.id.keyboard_view);
    }

    public void attachTo(EditText editText) {
        this.mEditText = editText;
        BaseKeyboard.hideSystemSofeKeyboard(this.mActivity.getApplicationContext(), this.mEditText);
        this.showSoftKeyboard();
        this.isAttached = true;
    }

    public void showSoftKeyboard() {
        if (this.Keyboard == null) {
            this.Keyboard = new Keyboard((Context)this.mActivity, this.layoutResId);
        }
        if (this.mKeyboardView == null) {
            this.mKeyboardView = (MyKeyBoardView)this.mActivity.findViewById(R.id.keyboard_view);
        }
        if (this.mIfRandom) {
            this.randomKeyboardNumber();
        } else {
            this.mKeyboardView.setKeyboard(this.Keyboard);
        }
        this.mKeyboardView.setKeyboard(this.Keyboard);
        this.mKeyboardView.setEnabled(true);
        this.mKeyboardView.setPreviewEnabled(false);
        this.mKeyboardView.setVisibility(0);
        this.mKeyboardView.setOnKeyboardActionListener(this.mOnKeyboardActionListener);
    }

    public static void hideSystemSofeKeyboard(Context context, EditText editText) {
        int sdkInt = Build.VERSION.SDK_INT;
        if (sdkInt >= 11) {
            try {
                Class<EditText> cls = EditText.class;
                Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
                setShowSoftInputOnFocus.setAccessible(true);
                setShowSoftInputOnFocus.invoke((Object)editText, false);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            editText.setInputType(0);
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }

    public void setOnOkClick(OnOkClick onOkClick) {
        this.mOnOkClick = onOkClick;
    }

    public void setOnCancelClick(onCancelClick onCancelClick2) {
        this.mOnCancelClick = onCancelClick2;
    }

    private boolean isNumber(String str) {
        String wordstr = "0123456789";
        return wordstr.contains(str) && !str.equals("");
    }

    private void randomKeyboardNumber() {
        int i;
        List keyList = this.Keyboard.getKeys();
        ArrayList newkeyList = new ArrayList();
        for (int i2 = 0; i2 < keyList.size(); ++i2) {
            if (((Keyboard.Key)keyList.get((int)i2)).label == null || !this.isNumber(((Keyboard.Key)keyList.get((int)i2)).label.toString())) continue;
            newkeyList.add(keyList.get(i2));
        }
        int count = newkeyList.size();
        ArrayList<KeyModel> resultList = new ArrayList<KeyModel>();
        LinkedList<KeyModel> temp = new LinkedList<KeyModel>();
        for (int i3 = 0; i3 < count; ++i3) {
            temp.add(new KeyModel(48 + i3, i3 + ""));
        }
        Random rand = new Random();
        for (i = 0; i < count; ++i) {
            int num = rand.nextInt(count - i);
            resultList.add(new KeyModel(((KeyModel)temp.get(num)).getCode(), ((KeyModel)temp.get(num)).getLable()));
            temp.remove(num);
        }
        for (i = 0; i < newkeyList.size(); ++i) {
            ((Keyboard.Key)newkeyList.get((int)i)).label = ((KeyModel)resultList.get(i)).getLable();
            ((Keyboard.Key)newkeyList.get((int)i)).codes[0] = ((KeyModel)resultList.get(i)).getCode();
        }
        this.mKeyboardView.setKeyboard(this.Keyboard);
    }

    public void showKeyboard() {
        int visibility = this.mKeyboardView.getVisibility();
        if (visibility == 8 || visibility == 4) {
            this.mKeyboardView.setVisibility(0);
        }
    }

    public void hideKeyboard() {
        int visibility = this.mKeyboardView.getVisibility();
        if (visibility == 0) {
            this.mKeyboardView.setVisibility(8);
        }
    }

    public static interface onCancelClick {
        public void onCancellClick();
    }

    public static interface OnOkClick {
        public void onOkClick();
    }
}

