/*
 * Decompiled with CFR 0.152.
 */
package diglol.crypto;

import diglol.crypto.Error;
import diglol.crypto.Mac;
import diglol.crypto.MacKt;
import diglol.crypto.internal.UtilKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\bH\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\bH\u0002J!\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Ldiglol/crypto/Poly1305;", "Ldiglol/crypto/Mac;", "key", "", "([B)V", "compute", "data", "macSize", "", "([BILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copyBlockSize", "", "output", "input", "idx", "load26", "", "shift", "load32", "size", "toByteArray", "num", "verify", "", "mac", "([B[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion"})
public final class Poly1305
implements Mac {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] key;
    public static final int MAC_TAG_SIZE = 16;
    public static final int MAC_KEY_SIZE = 32;

    public Poly1305(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
        if (this.key.length != 32) {
            throw new Error("The key length in bytes must be 32.");
        }
    }

    @Override
    public int size() {
        return 16;
    }

    @Override
    @JvmOverloads
    @Nullable
    public Object compute(@NotNull byte[] data, int macSize, @NotNull Continuation<? super byte[]> $completion) {
        MacKt.checkMacSize(this, macSize);
        long h0 = 0L;
        long h1 = 0L;
        long h2 = 0L;
        long h3 = 0L;
        long h4 = 0L;
        long d0 = 0L;
        long d1 = 0L;
        long d2 = 0L;
        long d3 = 0L;
        long d4 = 0L;
        long c = 0L;
        long r0 = this.load26(this.key, 0, 0) & 0x3FFFFFFL;
        long r1 = this.load26(this.key, 3, 2) & 0x3FFFF03L;
        long r2 = this.load26(this.key, 6, 4) & 0x3FFC0FFL;
        long r3 = this.load26(this.key, 9, 6) & 0x3F03FFFL;
        long r4 = this.load26(this.key, 12, 8) & 0xFFFFFL;
        long s1 = r1 * (long)5;
        long s2 = r2 * (long)5;
        long s3 = r3 * (long)5;
        long s4 = r4 * (long)5;
        byte[] buf = new byte[17];
        for (int i = 0; i < data.length; i += 16) {
            this.copyBlockSize(buf, data, i);
            d0 = (h0 += this.load26(buf, 0, 0)) * r0 + (h1 += this.load26(buf, 3, 2)) * s4 + (h2 += this.load26(buf, 6, 4)) * s3 + (h3 += this.load26(buf, 9, 6)) * s2 + (h4 += this.load26(buf, 12, 8) | (long)buf[16] << 24) * s1;
            d1 = h0 * r1 + h1 * r0 + h2 * s4 + h3 * s3 + h4 * s2;
            d2 = h0 * r2 + h1 * r1 + h2 * r0 + h3 * s4 + h4 * s3;
            d3 = h0 * r3 + h1 * r2 + h2 * r1 + h3 * r0 + h4 * s4;
            d4 = h0 * r4 + h1 * r3 + h2 * r2 + h3 * r1 + h4 * r0;
            c = d0 >> 26;
            h0 = d0 & 0x3FFFFFFL;
            d1 += c;
            c = d1 >> 26;
            h1 = d1 & 0x3FFFFFFL;
            d2 += c;
            c = d2 >> 26;
            h2 = d2 & 0x3FFFFFFL;
            d3 += c;
            c = d3 >> 26;
            h3 = d3 & 0x3FFFFFFL;
            d4 += c;
            c = d4 >> 26;
            h4 = d4 & 0x3FFFFFFL;
            h0 += c * (long)5;
            c = h0 >> 26;
            h0 &= 0x3FFFFFFL;
            h1 += c;
        }
        c = h1 >> 26;
        h1 &= 0x3FFFFFFL;
        h2 += c;
        c = h2 >> 26;
        h2 &= 0x3FFFFFFL;
        h3 += c;
        c = h3 >> 26;
        h3 &= 0x3FFFFFFL;
        h4 += c;
        c = h4 >> 26;
        h4 &= 0x3FFFFFFL;
        h0 += c * (long)5;
        c = h0 >> 26;
        h1 += c;
        long g0 = (h0 &= 0x3FFFFFFL) + (long)5;
        c = g0 >> 26;
        g0 &= 0x3FFFFFFL;
        long g1 = h1 + c;
        c = g1 >> 26;
        g1 &= 0x3FFFFFFL;
        long g2 = h2 + c;
        c = g2 >> 26;
        g2 &= 0x3FFFFFFL;
        long g3 = h3 + c;
        c = g3 >> 26;
        g3 &= 0x3FFFFFFL;
        long g4 = h4 + c - (long)0x4000000;
        long mask = g4 >> 63;
        h0 &= mask;
        h1 &= mask;
        h2 &= mask;
        h3 &= mask;
        h4 &= mask;
        h0 |= g0 & (mask ^= 0xFFFFFFFFFFFFFFFFL);
        h0 = (h0 | (h1 |= g1 & mask) << 26) & 0xFFFFFFFFL;
        h1 = (h1 >> 6 | (h2 |= g2 & mask) << 20) & 0xFFFFFFFFL;
        h2 = (h2 >> 12 | (h3 |= g3 & mask) << 14) & 0xFFFFFFFFL;
        h3 = (h3 >> 18 | (h4 |= g4 & mask) << 8) & 0xFFFFFFFFL;
        c = h0 + this.load32(this.key, 16);
        h0 = c & 0xFFFFFFFFL;
        c = h1 + this.load32(this.key, 20) + (c >> 32);
        h1 = c & 0xFFFFFFFFL;
        c = h2 + this.load32(this.key, 24) + (c >> 32);
        h2 = c & 0xFFFFFFFFL;
        c = h3 + this.load32(this.key, 28) + (c >> 32);
        h3 = c & 0xFFFFFFFFL;
        byte[] mac = new byte[16];
        this.toByteArray(mac, h0, 0);
        this.toByteArray(mac, h1, 4);
        this.toByteArray(mac, h2, 8);
        this.toByteArray(mac, h3, 12);
        return UtilKt.selfOrCopyOf((byte[])mac, (int)macSize);
    }

    @Override
    @Nullable
    public Object verify(@NotNull byte[] mac, @NotNull byte[] data, @NotNull Continuation<? super Boolean> $completion) {
        return MacKt.commonVerify(this, mac, data, $completion);
    }

    private final long load32(byte[] input, int idx) {
        return ((long)input[idx] & 0xFFL | ((long)input[idx + 1] & 0xFFL) << 8 | ((long)input[idx + 2] & 0xFFL) << 16 | ((long)input[idx + 3] & 0xFFL) << 24) & 0xFFFFFFFFL;
    }

    private final long load26(byte[] input, int idx, int shift) {
        return this.load32(input, idx) >> shift & 0x3FFFFFFL;
    }

    private final void toByteArray(byte[] output, long num, int idx) {
        output[idx] = (byte)(num >> 0 & 0xFFL);
        output[idx + 1] = (byte)(num >> 8 & 0xFFL);
        output[idx + 2] = (byte)(num >> 16 & 0xFFL);
        output[idx + 3] = (byte)(num >> 24 & 0xFFL);
    }

    private final void copyBlockSize(byte[] output, byte[] input, int idx) {
        int copyCount = Math.min(16, input.length - idx);
        ArraysKt.copyInto((byte[])input, (byte[])output, (int)0, (int)idx, (int)(idx + copyCount));
        output[copyCount] = 1;
        if (copyCount != 16) {
            ArraysKt.fill((byte[])output, (byte)0, (int)(copyCount + 1), (int)output.length);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldiglol/crypto/Poly1305$Companion;", "", "()V", "MAC_KEY_SIZE", "", "MAC_TAG_SIZE", "mac"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

