/*
 * Decompiled with CFR 0.152.
 */
package diglol.crypto;

import diglol.crypto.HmacKt;
import diglol.crypto.Mac;
import diglol.crypto.MacKt;
import diglol.crypto.internal.UtilKt;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0011H\u0016J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Ldiglol/crypto/Hmac;", "Ldiglol/crypto/Mac;", "type", "Ldiglol/crypto/Hmac$Type;", "key", "", "(Ldiglol/crypto/Hmac$Type;[B)V", "hmac", "Ljavax/crypto/Mac;", "kotlin.jvm.PlatformType", "getKey$mac", "()[B", "getType$mac", "()Ldiglol/crypto/Hmac$Type;", "compute", "data", "macSize", "", "([BILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "size", "verify", "", "mac", "([B[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Type"})
public final class Hmac
implements Mac {
    @NotNull
    private final Type type;
    @NotNull
    private final byte[] key;
    private final javax.crypto.Mac hmac;

    public Hmac(@NotNull Type type, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.type = type;
        this.key = key;
        this.hmac = javax.crypto.Mac.getInstance(this.type.typeName());
        HmacKt.checkParams(this);
        this.hmac.init(new SecretKeySpec(this.key, this.type.typeName()));
    }

    @NotNull
    public final Type getType$mac() {
        return this.type;
    }

    @NotNull
    public final byte[] getKey$mac() {
        return this.key;
    }

    @Override
    public int size() {
        return this.type.size();
    }

    @Override
    @JvmOverloads
    @Nullable
    public Object compute(@NotNull byte[] data, int macSize, @NotNull Continuation<? super byte[]> $completion) {
        MacKt.checkMacSize(this, macSize);
        this.hmac.update(data);
        byte[] byArray = this.hmac.doFinal();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hmac.doFinal()");
        return UtilKt.selfOrCopyOf((byte[])byArray, (int)macSize);
    }

    @Override
    @Nullable
    public Object verify(@NotNull byte[] mac, @NotNull byte[] data, @NotNull Continuation<? super Boolean> $completion) {
        return MacKt.commonVerify(this, mac, data, $completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Ldiglol/crypto/Hmac$Type;", "", "(Ljava/lang/String;I)V", "size", "", "typeName", "", "SHA1", "SHA256", "SHA384", "SHA512", "mac"})
    @SourceDebugExtension(value={"SMAP\nHmac.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hmac.kt\ndiglol/crypto/Hmac$Type\n+ 2 Hmac.kt\ndiglol/crypto/HmacKt\n*L\n1#1,48:1\n31#2,7:49\n*S KotlinDebug\n*F\n+ 1 Hmac.kt\ndiglol/crypto/Hmac$Type\n*L\n18#1:49,7\n*E\n"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SHA1 = new Type();
        public static final /* enum */ Type SHA256 = new Type();
        public static final /* enum */ Type SHA384 = new Type();
        public static final /* enum */ Type SHA512 = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public final int size() {
            int n;
            Type $this$commonSize$iv = this;
            boolean $i$f$commonSize = false;
            switch (HmacKt.WhenMappings.$EnumSwitchMapping$0[$this$commonSize$iv.ordinal()]) {
                case 1: {
                    n = 20;
                    break;
                }
                case 2: {
                    n = 32;
                    break;
                }
                case 3: {
                    n = 48;
                    break;
                }
                case 4: {
                    n = 64;
                    break;
                }
                default: {
                    String string = "https://youtrack.jetbrains.com/issue/KT-43875";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
            }
            return n;
        }

        @NotNull
        public final String typeName() {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string = "HmacSHA1";
                    break;
                }
                case 2: {
                    string = "HmacSHA256";
                    break;
                }
                case 3: {
                    string = "HmacSHA384";
                    break;
                }
                case 4: {
                    string = "HmacSHA512";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.SHA1, Type.SHA256, Type.SHA384, Type.SHA512};
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                try {
                    nArray[Type.SHA1.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.SHA256.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.SHA384.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.SHA512.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

