/*
 * Decompiled with CFR 0.152.
 */
package diglol.crypto;

import diglol.crypto.Cipher;
import diglol.crypto.Error;
import diglol.crypto.internal.UtilKt;
import diglol.crypto.random.Random;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\f\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0006J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0019\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Ldiglol/crypto/XChaCha20;", "Ldiglol/crypto/Cipher;", "key", "", "nonce", "initialCounter", "", "([B[BI)V", "keyInts", "", "chacha20Block", "counter", "createInitialState", "decrypt", "ciphertext", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "encrypt", "plaintext", "process", "data", "Companion", "cipher"})
public final class XChaCha20
implements Cipher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final byte[] nonce;
    private final int initialCounter;
    @NotNull
    private final int[] keyInts;
    public static final int BLOCK_INTS_SIZE = 16;
    public static final int BLOCK_SIZE = 64;
    public static final int KEY_INTS_SIZE = 8;
    public static final int KEY_SIZE = 32;
    public static final int NONCE_SIZE = 24;
    @NotNull
    private static final int[] SIGMA;

    @JvmOverloads
    public XChaCha20(@NotNull byte[] key, @Nullable byte[] nonce, int initialCounter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.nonce = nonce;
        this.initialCounter = initialCounter;
        if (key.length != 32) {
            throw new Error("The key length in bytes must be 32");
        }
        if (this.nonce != null && this.nonce.length != 24) {
            throw new Error("Nonce length in bytes must be 32");
        }
        this.keyInts = XChaCha20.Companion.toIntArray(key);
    }

    public /* synthetic */ XChaCha20(byte[] byArray, byte[] byArray2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            byArray2 = null;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(byArray, byArray2, n);
    }

    @Override
    @Nullable
    public Object encrypt(@NotNull byte[] plaintext, @NotNull Continuation<? super byte[]> $completion) {
        if (plaintext.length > 0x7FFFFFE7) {
            throw new Error("Plaintext too long");
        }
        byte[] byArray = this.nonce;
        if (this.nonce == null) {
            byArray = Random.nextBytes((int)24);
        }
        byte[] realNonce = byArray;
        return ArraysKt.plus((byte[])realNonce, (byte[])this.process(realNonce, plaintext));
    }

    @Override
    @Nullable
    public Object decrypt(@NotNull byte[] ciphertext, @NotNull Continuation<? super byte[]> $completion) {
        if (ciphertext.length < 24) {
            throw new Error("Ciphertext too short");
        }
        byte[] byArray = Arrays.copyOf(ciphertext, 24);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        byte[] nonce = byArray;
        byte[] byArray2 = ciphertext;
        int n = 24;
        int n2 = ciphertext.length;
        byte[] rawCiphertext = ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)n2);
        return this.process(nonce, rawCiphertext);
    }

    private final byte[] process(byte[] nonce, byte[] data) {
        byte[] out = new byte[data.length];
        int numBlocks = data.length / 64 + 1;
        for (int i = 0; i < numBlocks; ++i) {
            byte[] keyBytesBlock = this.chacha20Block(nonce, i + this.initialCounter);
            int offset = i * 64;
            byte[] bytesBlock = i == numBlocks - 1 ? XChaCha20.Companion.xor(data, offset, keyBytesBlock, data.length % 64) : XChaCha20.Companion.xor(data, offset, keyBytesBlock, 64);
            ArraysKt.copyInto((byte[])bytesBlock, (byte[])out, (int)offset, (int)0, (int)bytesBlock.length);
        }
        return out;
    }

    @NotNull
    public final byte[] chacha20Block(@NotNull byte[] nonce, int counter) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        int[] state = this.createInitialState(XChaCha20.Companion.toIntArray(nonce), counter);
        int[] nArray = Arrays.copyOf(state, state.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, size)");
        int[] workingState = nArray;
        XChaCha20.Companion.shuffleState(workingState);
        int n = state.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            state[n2] = state[n2] + workingState[i];
        }
        return XChaCha20.Companion.toByteArray(state);
    }

    private final int[] createInitialState(int[] nonce, int counter) {
        if (nonce.length != 6) {
            throw new Error("XChaCha20 uses 192-bit nonces, but got a " + nonce.length * 32 + "-bit nonce");
        }
        int[] state = new int[16];
        XChaCha20.Companion.setSigmaAndKey(state, XChaCha20.Companion.hChaCha20(this.keyInts, nonce));
        state[12] = counter;
        state[13] = 0;
        state[14] = nonce[4];
        state[15] = nonce[5];
        return state;
    }

    @JvmOverloads
    public XChaCha20(@NotNull byte[] key, @Nullable byte[] nonce) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this(key, nonce, 0, 4, null);
    }

    @JvmOverloads
    public XChaCha20(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this(key, null, 0, 6, null);
    }

    static {
        int[] nArray = new int[]{1634760805, 857760878, 2036477234, 1797285236};
        SIGMA = nArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\nH\u0002J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\f\u0010\u001e\u001a\u00020\u001b*\u00020\nH\u0002J\f\u0010\u001f\u001a\u00020\n*\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldiglol/crypto/XChaCha20$Companion;", "", "()V", "BLOCK_INTS_SIZE", "", "BLOCK_SIZE", "KEY_INTS_SIZE", "KEY_SIZE", "NONCE_SIZE", "SIGMA", "", "hChaCha20", "key", "nonce", "quarterRound", "", "x", "a", "b", "c", "d", "rotateLeft", "y", "setSigmaAndKey", "state", "shuffleState", "xor", "", "xStartIndex", "len", "toByteArray", "toIntArray", "cipher"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] hChaCha20(int[] key, int[] nonce) {
            int[] state = new int[16];
            this.setSigmaAndKey(state, key);
            state[12] = nonce[0];
            state[13] = nonce[1];
            state[14] = nonce[2];
            state[15] = nonce[3];
            this.shuffleState(state);
            state[4] = state[12];
            state[5] = state[13];
            state[6] = state[14];
            state[7] = state[15];
            int[] nArray = Arrays.copyOf(state, 8);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            return nArray;
        }

        private final void setSigmaAndKey(int[] state, int[] key) {
            ArraysKt.copyInto((int[])SIGMA, (int[])state, (int)0, (int)0, (int)SIGMA.length);
            ArraysKt.copyInto((int[])key, (int[])state, (int)SIGMA.length, (int)0, (int)8);
        }

        private final void shuffleState(int[] state) {
            for (int i = 0; i < 10; ++i) {
                this.quarterRound(state, 0, 4, 8, 12);
                this.quarterRound(state, 1, 5, 9, 13);
                this.quarterRound(state, 2, 6, 10, 14);
                this.quarterRound(state, 3, 7, 11, 15);
                this.quarterRound(state, 0, 5, 10, 15);
                this.quarterRound(state, 1, 6, 11, 12);
                this.quarterRound(state, 2, 7, 8, 13);
                this.quarterRound(state, 3, 4, 9, 14);
            }
        }

        private final void quarterRound(int[] x, int a, int b, int c, int d) {
            x[a] = x[a] + x[b];
            x[d] = this.rotateLeft(x[d] ^ x[a], 16);
            x[c] = x[c] + x[d];
            x[b] = this.rotateLeft(x[b] ^ x[c], 12);
            x[a] = x[a] + x[b];
            x[d] = this.rotateLeft(x[d] ^ x[a], 8);
            x[c] = x[c] + x[d];
            x[b] = this.rotateLeft(x[b] ^ x[c], 7);
        }

        private final int rotateLeft(int x, int y) {
            return x << y | x >>> -y;
        }

        private final int[] toIntArray(byte[] $this$toIntArray) {
            int size = $this$toIntArray.length / 4;
            int[] ints = new int[size];
            for (int i = 0; i < size; ++i) {
                int startIdx = i * 4;
                byte[] byArray = $this$toIntArray;
                int n = startIdx + 4;
                Integer n2 = UtilKt.toInt((byte[])ArraysKt.copyOfRange((byte[])byArray, (int)startIdx, (int)n), (boolean)false);
                Intrinsics.checkNotNull((Object)n2);
                ints[i] = n2;
            }
            return ints;
        }

        private final byte[] toByteArray(int[] $this$toByteArray) {
            byte[] bytes = new byte[$this$toByteArray.length * 4];
            int n = $this$toByteArray.length;
            for (int i = 0; i < n; ++i) {
                ArraysKt.copyInto((byte[])UtilKt.toByteArray((int)$this$toByteArray[i], (boolean)false), (byte[])bytes, (int)(i * 4), (int)0, (int)4);
            }
            return bytes;
        }

        private final byte[] xor(byte[] x, int xStartIndex, byte[] y, int len) {
            if (len < 0 || x.length < len || y.length < len) {
                throw new Error("That combination of buffers, offsets and length to xor result in out-of-bond accesses.");
            }
            byte[] res = new byte[len];
            for (int i = 0; i < len; ++i) {
                res[i] = (byte)(x[xStartIndex + i] ^ y[i]);
            }
            return res;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

